/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmp;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.snmp.Definition;
import org.xml.sax.ContentHandler;

public class SnmpConfig
implements Serializable {
    private int _port;
    private boolean _has_port;
    private int _retry;
    private boolean _has_retry;
    private int _timeout;
    private boolean _has_timeout;
    private String _readCommunity;
    private String _writeCommunity;
    private String _proxyHost;
    private String _version;
    private int _maxVarsPerPdu = 10;
    private boolean _has_maxVarsPerPdu;
    private int _maxRequestSize = 65535;
    private boolean _has_maxRequestSize;
    private String _securityName;
    private String _authPassphrase;
    private String _authProtocol;
    private String _engineId;
    private String _contextEngineId;
    private String _contextName;
    private String _privacyPassphrase;
    private String _privacyProtocol;
    private String _enterpriseId;
    private ArrayList _definitionList = new ArrayList();

    public void addDefinition(Definition vDefinition) throws IndexOutOfBoundsException {
        this._definitionList.add(vDefinition);
    }

    public void addDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        this._definitionList.add(index, vDefinition);
    }

    public void clearDefinition() {
        this._definitionList.clear();
    }

    public void deleteMaxRequestSize() {
        this._has_maxRequestSize = false;
    }

    public void deleteMaxVarsPerPdu() {
        this._has_maxVarsPerPdu = false;
    }

    public void deletePort() {
        this._has_port = false;
    }

    public void deleteRetry() {
        this._has_retry = false;
    }

    public void deleteTimeout() {
        this._has_timeout = false;
    }

    public Enumeration enumerateDefinition() {
        return new IteratorEnumeration(this._definitionList.iterator());
    }

    public String getAuthPassphrase() {
        return this._authPassphrase;
    }

    public String getAuthProtocol() {
        return this._authProtocol;
    }

    public String getContextEngineId() {
        return this._contextEngineId;
    }

    public String getContextName() {
        return this._contextName;
    }

    public Definition getDefinition(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._definitionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Definition)this._definitionList.get(index);
    }

    public Definition[] getDefinition() {
        int size = this._definitionList.size();
        Definition[] mArray = new Definition[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Definition)this._definitionList.get(index);
        }
        return mArray;
    }

    public ArrayList getDefinitionCollection() {
        return this._definitionList;
    }

    public int getDefinitionCount() {
        return this._definitionList.size();
    }

    public String getEngineId() {
        return this._engineId;
    }

    public String getEnterpriseId() {
        return this._enterpriseId;
    }

    public int getMaxRequestSize() {
        return this._maxRequestSize;
    }

    public int getMaxVarsPerPdu() {
        return this._maxVarsPerPdu;
    }

    public int getPort() {
        return this._port;
    }

    public String getPrivacyPassphrase() {
        return this._privacyPassphrase;
    }

    public String getPrivacyProtocol() {
        return this._privacyProtocol;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public String getReadCommunity() {
        return this._readCommunity;
    }

    public int getRetry() {
        return this._retry;
    }

    public String getSecurityName() {
        return this._securityName;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public String getVersion() {
        return this._version;
    }

    public String getWriteCommunity() {
        return this._writeCommunity;
    }

    public boolean hasMaxRequestSize() {
        return this._has_maxRequestSize;
    }

    public boolean hasMaxVarsPerPdu() {
        return this._has_maxVarsPerPdu;
    }

    public boolean hasPort() {
        return this._has_port;
    }

    public boolean hasRetry() {
        return this._has_retry;
    }

    public boolean hasTimeout() {
        return this._has_timeout;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeDefinition(Definition vDefinition) {
        boolean removed = this._definitionList.remove(vDefinition);
        return removed;
    }

    public void setAuthPassphrase(String authPassphrase) {
        this._authPassphrase = authPassphrase;
    }

    public void setAuthProtocol(String authProtocol) {
        this._authProtocol = authProtocol;
    }

    public void setContextEngineId(String contextEngineId) {
        this._contextEngineId = contextEngineId;
    }

    public void setContextName(String contextName) {
        this._contextName = contextName;
    }

    public void setDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._definitionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._definitionList.set(index, vDefinition);
    }

    public void setDefinition(Definition[] definitionArray) {
        this._definitionList.clear();
        for (int i = 0; i < definitionArray.length; ++i) {
            this._definitionList.add(definitionArray[i]);
        }
    }

    public void setDefinition(ArrayList definitionCollection) {
        this._definitionList.clear();
        for (int i = 0; i < definitionCollection.size(); ++i) {
            this._definitionList.add((Definition)definitionCollection.get(i));
        }
    }

    public void setDefinitionCollection(ArrayList definitionCollection) {
        this._definitionList = definitionCollection;
    }

    public void setEngineId(String engineId) {
        this._engineId = engineId;
    }

    public void setEnterpriseId(String enterpriseId) {
        this._enterpriseId = enterpriseId;
    }

    public void setMaxRequestSize(int maxRequestSize) {
        this._maxRequestSize = maxRequestSize;
        this._has_maxRequestSize = true;
    }

    public void setMaxVarsPerPdu(int maxVarsPerPdu) {
        this._maxVarsPerPdu = maxVarsPerPdu;
        this._has_maxVarsPerPdu = true;
    }

    public void setPort(int port) {
        this._port = port;
        this._has_port = true;
    }

    public void setPrivacyPassphrase(String privacyPassphrase) {
        this._privacyPassphrase = privacyPassphrase;
    }

    public void setPrivacyProtocol(String privacyProtocol) {
        this._privacyProtocol = privacyProtocol;
    }

    public void setProxyHost(String proxyHost) {
        this._proxyHost = proxyHost;
    }

    public void setReadCommunity(String readCommunity) {
        this._readCommunity = readCommunity;
    }

    public void setRetry(int retry) {
        this._retry = retry;
        this._has_retry = true;
    }

    public void setSecurityName(String securityName) {
        this._securityName = securityName;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
        this._has_timeout = true;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setWriteCommunity(String writeCommunity) {
        this._writeCommunity = writeCommunity;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (SnmpConfig)Unmarshaller.unmarshal(SnmpConfig.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

