/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.service;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.service.Service;
import org.xml.sax.ContentHandler;

public class ServiceConfiguration
implements Serializable {
    private ArrayList _serviceList = new ArrayList();

    public void addService(Service vService) throws IndexOutOfBoundsException {
        this._serviceList.add(vService);
    }

    public void addService(int index, Service vService) throws IndexOutOfBoundsException {
        this._serviceList.add(index, vService);
    }

    public void clearService() {
        this._serviceList.clear();
    }

    public Enumeration enumerateService() {
        return new IteratorEnumeration(this._serviceList.iterator());
    }

    public Service getService(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._serviceList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Service)this._serviceList.get(index);
    }

    public Service[] getService() {
        int size = this._serviceList.size();
        Service[] mArray = new Service[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Service)this._serviceList.get(index);
        }
        return mArray;
    }

    public ArrayList getServiceCollection() {
        return this._serviceList;
    }

    public int getServiceCount() {
        return this._serviceList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeService(Service vService) {
        boolean removed = this._serviceList.remove(vService);
        return removed;
    }

    public void setService(int index, Service vService) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._serviceList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._serviceList.set(index, vService);
    }

    public void setService(Service[] serviceArray) {
        this._serviceList.clear();
        for (int i = 0; i < serviceArray.length; ++i) {
            this._serviceList.add(serviceArray[i]);
        }
    }

    public void setService(ArrayList serviceCollection) {
        this._serviceList.clear();
        for (int i = 0; i < serviceCollection.size(); ++i) {
            this._serviceList.add((Service)serviceCollection.get(i));
        }
    }

    public void setServiceCollection(ArrayList serviceCollection) {
        this._serviceList = serviceCollection;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (ServiceConfiguration)Unmarshaller.unmarshal(ServiceConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

