/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.service;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.service.Argument;
import org.opennms.netmgt.config.service.types.InvokeAtType;
import org.xml.sax.ContentHandler;

public class Invoke
implements Serializable {
    private String _method;
    private int _pass = 0;
    private boolean _has_pass;
    private InvokeAtType _at;
    private ArrayList _argumentList = new ArrayList();

    public void addArgument(Argument vArgument) throws IndexOutOfBoundsException {
        this._argumentList.add(vArgument);
    }

    public void addArgument(int index, Argument vArgument) throws IndexOutOfBoundsException {
        this._argumentList.add(index, vArgument);
    }

    public void clearArgument() {
        this._argumentList.clear();
    }

    public void deletePass() {
        this._has_pass = false;
    }

    public Enumeration enumerateArgument() {
        return new IteratorEnumeration(this._argumentList.iterator());
    }

    public Argument getArgument(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._argumentList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Argument)this._argumentList.get(index);
    }

    public Argument[] getArgument() {
        int size = this._argumentList.size();
        Argument[] mArray = new Argument[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Argument)this._argumentList.get(index);
        }
        return mArray;
    }

    public ArrayList getArgumentCollection() {
        return this._argumentList;
    }

    public int getArgumentCount() {
        return this._argumentList.size();
    }

    public InvokeAtType getAt() {
        return this._at;
    }

    public String getMethod() {
        return this._method;
    }

    public int getPass() {
        return this._pass;
    }

    public boolean hasPass() {
        return this._has_pass;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeArgument(Argument vArgument) {
        boolean removed = this._argumentList.remove(vArgument);
        return removed;
    }

    public void setArgument(int index, Argument vArgument) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._argumentList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._argumentList.set(index, vArgument);
    }

    public void setArgument(Argument[] argumentArray) {
        this._argumentList.clear();
        for (int i = 0; i < argumentArray.length; ++i) {
            this._argumentList.add(argumentArray[i]);
        }
    }

    public void setArgument(ArrayList argumentCollection) {
        this._argumentList.clear();
        for (int i = 0; i < argumentCollection.size(); ++i) {
            this._argumentList.add((Argument)argumentCollection.get(i));
        }
    }

    public void setArgumentCollection(ArrayList argumentCollection) {
        this._argumentList = argumentCollection;
    }

    public void setAt(InvokeAtType at) {
        this._at = at;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setPass(int pass) {
        this._pass = pass;
        this._has_pass = true;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Invoke)Unmarshaller.unmarshal(Invoke.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

