/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.poller;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.NodeOutage;
import org.opennms.netmgt.config.poller.Package;
import org.xml.sax.ContentHandler;

public class PollerConfiguration
implements Serializable {
    private int _threads;
    private boolean _has_threads;
    private String _nextOutageId;
    private String _serviceUnresponsiveEnabled;
    private String _xmlrpc = "false";
    private String _pathOutageEnabled = "false";
    private NodeOutage _nodeOutage;
    private ArrayList _packageList;
    private ArrayList _monitorList;

    public PollerConfiguration() {
        this.setXmlrpc("false");
        this.setPathOutageEnabled("false");
        this._packageList = new ArrayList();
        this._monitorList = new ArrayList();
    }

    public void addMonitor(Monitor vMonitor) throws IndexOutOfBoundsException {
        this._monitorList.add(vMonitor);
    }

    public void addMonitor(int index, Monitor vMonitor) throws IndexOutOfBoundsException {
        this._monitorList.add(index, vMonitor);
    }

    public void addPackage(Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(vPackage);
    }

    public void addPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(index, vPackage);
    }

    public void clearMonitor() {
        this._monitorList.clear();
    }

    public void clearPackage() {
        this._packageList.clear();
    }

    public void deleteThreads() {
        this._has_threads = false;
    }

    public Enumeration enumerateMonitor() {
        return new IteratorEnumeration(this._monitorList.iterator());
    }

    public Enumeration enumeratePackage() {
        return new IteratorEnumeration(this._packageList.iterator());
    }

    public Monitor getMonitor(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._monitorList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Monitor)this._monitorList.get(index);
    }

    public Monitor[] getMonitor() {
        int size = this._monitorList.size();
        Monitor[] mArray = new Monitor[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Monitor)this._monitorList.get(index);
        }
        return mArray;
    }

    public ArrayList getMonitorCollection() {
        return this._monitorList;
    }

    public int getMonitorCount() {
        return this._monitorList.size();
    }

    public String getNextOutageId() {
        return this._nextOutageId;
    }

    public NodeOutage getNodeOutage() {
        return this._nodeOutage;
    }

    public Package getPackage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._packageList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Package)this._packageList.get(index);
    }

    public Package[] getPackage() {
        int size = this._packageList.size();
        Package[] mArray = new Package[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Package)this._packageList.get(index);
        }
        return mArray;
    }

    public ArrayList getPackageCollection() {
        return this._packageList;
    }

    public int getPackageCount() {
        return this._packageList.size();
    }

    public String getPathOutageEnabled() {
        return this._pathOutageEnabled;
    }

    public String getServiceUnresponsiveEnabled() {
        return this._serviceUnresponsiveEnabled;
    }

    public int getThreads() {
        return this._threads;
    }

    public String getXmlrpc() {
        return this._xmlrpc;
    }

    public boolean hasThreads() {
        return this._has_threads;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeMonitor(Monitor vMonitor) {
        boolean removed = this._monitorList.remove(vMonitor);
        return removed;
    }

    public boolean removePackage(Package vPackage) {
        boolean removed = this._packageList.remove(vPackage);
        return removed;
    }

    public void setMonitor(int index, Monitor vMonitor) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._monitorList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._monitorList.set(index, vMonitor);
    }

    public void setMonitor(Monitor[] monitorArray) {
        this._monitorList.clear();
        for (int i = 0; i < monitorArray.length; ++i) {
            this._monitorList.add(monitorArray[i]);
        }
    }

    public void setMonitor(ArrayList monitorCollection) {
        this._monitorList.clear();
        for (int i = 0; i < monitorCollection.size(); ++i) {
            this._monitorList.add((Monitor)monitorCollection.get(i));
        }
    }

    public void setMonitorCollection(ArrayList monitorCollection) {
        this._monitorList = monitorCollection;
    }

    public void setNextOutageId(String nextOutageId) {
        this._nextOutageId = nextOutageId;
    }

    public void setNodeOutage(NodeOutage nodeOutage) {
        this._nodeOutage = nodeOutage;
    }

    public void setPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._packageList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._packageList.set(index, vPackage);
    }

    public void setPackage(Package[] _packageArray) {
        this._packageList.clear();
        for (int i = 0; i < _packageArray.length; ++i) {
            this._packageList.add(_packageArray[i]);
        }
    }

    public void setPackage(ArrayList _packageCollection) {
        this._packageList.clear();
        for (int i = 0; i < _packageCollection.size(); ++i) {
            this._packageList.add((Package)_packageCollection.get(i));
        }
    }

    public void setPackageCollection(ArrayList _packageCollection) {
        this._packageList = _packageCollection;
    }

    public void setPathOutageEnabled(String pathOutageEnabled) {
        this._pathOutageEnabled = pathOutageEnabled;
    }

    public void setServiceUnresponsiveEnabled(String serviceUnresponsiveEnabled) {
        this._serviceUnresponsiveEnabled = serviceUnresponsiveEnabled;
    }

    public void setThreads(int threads) {
        this._threads = threads;
        this._has_threads = true;
    }

    public void setXmlrpc(String xmlrpc) {
        this._xmlrpc = xmlrpc;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (PollerConfiguration)Unmarshaller.unmarshal(PollerConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

