/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.pagesequence;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.pagesequence.Page;
import org.xml.sax.ContentHandler;

public class PageSequence
implements Serializable {
    private ArrayList _pageList = new ArrayList();

    public void addPage(Page vPage) throws IndexOutOfBoundsException {
        this._pageList.add(vPage);
    }

    public void addPage(int index, Page vPage) throws IndexOutOfBoundsException {
        this._pageList.add(index, vPage);
    }

    public void clearPage() {
        this._pageList.clear();
    }

    public Enumeration enumeratePage() {
        return new IteratorEnumeration(this._pageList.iterator());
    }

    public Page getPage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._pageList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Page)this._pageList.get(index);
    }

    public Page[] getPage() {
        int size = this._pageList.size();
        Page[] mArray = new Page[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Page)this._pageList.get(index);
        }
        return mArray;
    }

    public ArrayList getPageCollection() {
        return this._pageList;
    }

    public int getPageCount() {
        return this._pageList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removePage(Page vPage) {
        boolean removed = this._pageList.remove(vPage);
        return removed;
    }

    public void setPage(int index, Page vPage) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._pageList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._pageList.set(index, vPage);
    }

    public void setPage(Page[] pageArray) {
        this._pageList.clear();
        for (int i = 0; i < pageArray.length; ++i) {
            this._pageList.add(pageArray[i]);
        }
    }

    public void setPage(ArrayList pageCollection) {
        this._pageList.clear();
        for (int i = 0; i < pageCollection.size(); ++i) {
            this._pageList.add((Page)pageCollection.get(i));
        }
    }

    public void setPageCollection(ArrayList pageCollection) {
        this._pageList = pageCollection;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (PageSequence)Unmarshaller.unmarshal(PageSequence.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

