/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.nsclient;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.nsclient.Definition;
import org.xml.sax.ContentHandler;

public class NsclientConfig
implements Serializable {
    private int _port;
    private boolean _has_port;
    private int _retry;
    private boolean _has_retry;
    private int _timeout;
    private boolean _has_timeout;
    private String _password;
    private ArrayList _definitionList = new ArrayList();

    public void addDefinition(Definition vDefinition) throws IndexOutOfBoundsException {
        this._definitionList.add(vDefinition);
    }

    public void addDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        this._definitionList.add(index, vDefinition);
    }

    public void clearDefinition() {
        this._definitionList.clear();
    }

    public void deletePort() {
        this._has_port = false;
    }

    public void deleteRetry() {
        this._has_retry = false;
    }

    public void deleteTimeout() {
        this._has_timeout = false;
    }

    public Enumeration enumerateDefinition() {
        return new IteratorEnumeration(this._definitionList.iterator());
    }

    public Definition getDefinition(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._definitionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Definition)this._definitionList.get(index);
    }

    public Definition[] getDefinition() {
        int size = this._definitionList.size();
        Definition[] mArray = new Definition[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Definition)this._definitionList.get(index);
        }
        return mArray;
    }

    public ArrayList getDefinitionCollection() {
        return this._definitionList;
    }

    public int getDefinitionCount() {
        return this._definitionList.size();
    }

    public String getPassword() {
        return this._password;
    }

    public int getPort() {
        return this._port;
    }

    public int getRetry() {
        return this._retry;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public boolean hasPort() {
        return this._has_port;
    }

    public boolean hasRetry() {
        return this._has_retry;
    }

    public boolean hasTimeout() {
        return this._has_timeout;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeDefinition(Definition vDefinition) {
        boolean removed = this._definitionList.remove(vDefinition);
        return removed;
    }

    public void setDefinition(int index, Definition vDefinition) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._definitionList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._definitionList.set(index, vDefinition);
    }

    public void setDefinition(Definition[] definitionArray) {
        this._definitionList.clear();
        for (int i = 0; i < definitionArray.length; ++i) {
            this._definitionList.add(definitionArray[i]);
        }
    }

    public void setDefinition(ArrayList definitionCollection) {
        this._definitionList.clear();
        for (int i = 0; i < definitionCollection.size(); ++i) {
            this._definitionList.add((Definition)definitionCollection.get(i));
        }
    }

    public void setDefinitionCollection(ArrayList definitionCollection) {
        this._definitionList = definitionCollection;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setPort(int port) {
        this._port = port;
        this._has_port = true;
    }

    public void setRetry(int retry) {
        this._retry = retry;
        this._has_retry = true;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
        this._has_timeout = true;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (NsclientConfig)Unmarshaller.unmarshal(NsclientConfig.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

