/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notifications;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.common.Header;
import org.opennms.netmgt.config.notifications.Notification;
import org.xml.sax.ContentHandler;

public class Notifications
implements Serializable {
    private Header _header;
    private ArrayList _notificationList = new ArrayList();

    public void addNotification(Notification vNotification) throws IndexOutOfBoundsException {
        this._notificationList.add(vNotification);
    }

    public void addNotification(int index, Notification vNotification) throws IndexOutOfBoundsException {
        this._notificationList.add(index, vNotification);
    }

    public void clearNotification() {
        this._notificationList.clear();
    }

    public Enumeration enumerateNotification() {
        return new IteratorEnumeration(this._notificationList.iterator());
    }

    public Header getHeader() {
        return this._header;
    }

    public Notification getNotification(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._notificationList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Notification)this._notificationList.get(index);
    }

    public Notification[] getNotification() {
        int size = this._notificationList.size();
        Notification[] mArray = new Notification[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Notification)this._notificationList.get(index);
        }
        return mArray;
    }

    public ArrayList getNotificationCollection() {
        return this._notificationList;
    }

    public int getNotificationCount() {
        return this._notificationList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeNotification(Notification vNotification) {
        boolean removed = this._notificationList.remove(vNotification);
        return removed;
    }

    public void setHeader(Header header) {
        this._header = header;
    }

    public void setNotification(int index, Notification vNotification) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._notificationList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._notificationList.set(index, vNotification);
    }

    public void setNotification(Notification[] notificationArray) {
        this._notificationList.clear();
        for (int i = 0; i < notificationArray.length; ++i) {
            this._notificationList.add(notificationArray[i]);
        }
    }

    public void setNotification(ArrayList notificationCollection) {
        this._notificationList.clear();
        for (int i = 0; i < notificationCollection.size(); ++i) {
            this._notificationList.add((Notification)notificationCollection.get(i));
        }
    }

    public void setNotificationCollection(ArrayList notificationCollection) {
        this._notificationList = notificationCollection;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Notifications)Unmarshaller.unmarshal(Notifications.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

