/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.notificationCommands;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.notificationCommands.Command;
import org.opennms.netmgt.config.notificationCommands.Header;
import org.xml.sax.ContentHandler;

public class NotificationCommands
implements Serializable {
    private Header _header;
    private ArrayList _commandList = new ArrayList();

    public void addCommand(Command vCommand) throws IndexOutOfBoundsException {
        this._commandList.add(vCommand);
    }

    public void addCommand(int index, Command vCommand) throws IndexOutOfBoundsException {
        this._commandList.add(index, vCommand);
    }

    public void clearCommand() {
        this._commandList.clear();
    }

    public Enumeration enumerateCommand() {
        return new IteratorEnumeration(this._commandList.iterator());
    }

    public Command getCommand(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._commandList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Command)this._commandList.get(index);
    }

    public Command[] getCommand() {
        int size = this._commandList.size();
        Command[] mArray = new Command[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Command)this._commandList.get(index);
        }
        return mArray;
    }

    public ArrayList getCommandCollection() {
        return this._commandList;
    }

    public int getCommandCount() {
        return this._commandList.size();
    }

    public Header getHeader() {
        return this._header;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeCommand(Command vCommand) {
        boolean removed = this._commandList.remove(vCommand);
        return removed;
    }

    public void setCommand(int index, Command vCommand) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._commandList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._commandList.set(index, vCommand);
    }

    public void setCommand(Command[] commandArray) {
        this._commandList.clear();
        for (int i = 0; i < commandArray.length; ++i) {
            this._commandList.add(commandArray[i]);
        }
    }

    public void setCommand(ArrayList commandCollection) {
        this._commandList.clear();
        for (int i = 0; i < commandCollection.size(); ++i) {
            this._commandList.add((Command)commandCollection.get(i));
        }
    }

    public void setCommandCollection(ArrayList commandCollection) {
        this._commandList = commandCollection;
    }

    public void setHeader(Header header) {
        this._header = header;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (NotificationCommands)Unmarshaller.unmarshal(NotificationCommands.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

