/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.modelimport;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.modelimport.Category;
import org.opennms.netmgt.config.modelimport.MonitoredService;
import org.xml.sax.ContentHandler;

public class Interface
implements Serializable {
    private String _ipAddr;
    private Object _descr;
    private int _status = 1;
    private boolean _has_status;
    private boolean _managed = true;
    private boolean _has_managed;
    private String _snmpPrimary;
    private ArrayList _monitoredServiceList = new ArrayList();
    private ArrayList _categoryList = new ArrayList();

    public void addCategory(Category vCategory) throws IndexOutOfBoundsException {
        this._categoryList.add(vCategory);
    }

    public void addCategory(int index, Category vCategory) throws IndexOutOfBoundsException {
        this._categoryList.add(index, vCategory);
    }

    public void addMonitoredService(MonitoredService vMonitoredService) throws IndexOutOfBoundsException {
        this._monitoredServiceList.add(vMonitoredService);
    }

    public void addMonitoredService(int index, MonitoredService vMonitoredService) throws IndexOutOfBoundsException {
        this._monitoredServiceList.add(index, vMonitoredService);
    }

    public void clearCategory() {
        this._categoryList.clear();
    }

    public void clearMonitoredService() {
        this._monitoredServiceList.clear();
    }

    public void deleteManaged() {
        this._has_managed = false;
    }

    public void deleteStatus() {
        this._has_status = false;
    }

    public Enumeration enumerateCategory() {
        return new IteratorEnumeration(this._categoryList.iterator());
    }

    public Enumeration enumerateMonitoredService() {
        return new IteratorEnumeration(this._monitoredServiceList.iterator());
    }

    public Category getCategory(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._categoryList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Category)this._categoryList.get(index);
    }

    public Category[] getCategory() {
        int size = this._categoryList.size();
        Category[] mArray = new Category[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Category)this._categoryList.get(index);
        }
        return mArray;
    }

    public ArrayList getCategoryCollection() {
        return this._categoryList;
    }

    public int getCategoryCount() {
        return this._categoryList.size();
    }

    public Object getDescr() {
        return this._descr;
    }

    public String getIpAddr() {
        return this._ipAddr;
    }

    public boolean getManaged() {
        return this._managed;
    }

    public MonitoredService getMonitoredService(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._monitoredServiceList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (MonitoredService)this._monitoredServiceList.get(index);
    }

    public MonitoredService[] getMonitoredService() {
        int size = this._monitoredServiceList.size();
        MonitoredService[] mArray = new MonitoredService[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (MonitoredService)this._monitoredServiceList.get(index);
        }
        return mArray;
    }

    public ArrayList getMonitoredServiceCollection() {
        return this._monitoredServiceList;
    }

    public int getMonitoredServiceCount() {
        return this._monitoredServiceList.size();
    }

    public String getSnmpPrimary() {
        return this._snmpPrimary;
    }

    public int getStatus() {
        return this._status;
    }

    public boolean hasManaged() {
        return this._has_managed;
    }

    public boolean hasStatus() {
        return this._has_status;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeCategory(Category vCategory) {
        boolean removed = this._categoryList.remove(vCategory);
        return removed;
    }

    public boolean removeMonitoredService(MonitoredService vMonitoredService) {
        boolean removed = this._monitoredServiceList.remove(vMonitoredService);
        return removed;
    }

    public void setCategory(int index, Category vCategory) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._categoryList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._categoryList.set(index, vCategory);
    }

    public void setCategory(Category[] categoryArray) {
        this._categoryList.clear();
        for (int i = 0; i < categoryArray.length; ++i) {
            this._categoryList.add(categoryArray[i]);
        }
    }

    public void setCategory(ArrayList categoryCollection) {
        this._categoryList.clear();
        for (int i = 0; i < categoryCollection.size(); ++i) {
            this._categoryList.add((Category)categoryCollection.get(i));
        }
    }

    public void setCategoryCollection(ArrayList categoryCollection) {
        this._categoryList = categoryCollection;
    }

    public void setDescr(Object descr) {
        this._descr = descr;
    }

    public void setIpAddr(String ipAddr) {
        this._ipAddr = ipAddr;
    }

    public void setManaged(boolean managed) {
        this._managed = managed;
        this._has_managed = true;
    }

    public void setMonitoredService(int index, MonitoredService vMonitoredService) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._monitoredServiceList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._monitoredServiceList.set(index, vMonitoredService);
    }

    public void setMonitoredService(MonitoredService[] monitoredServiceArray) {
        this._monitoredServiceList.clear();
        for (int i = 0; i < monitoredServiceArray.length; ++i) {
            this._monitoredServiceList.add(monitoredServiceArray[i]);
        }
    }

    public void setMonitoredService(ArrayList monitoredServiceCollection) {
        this._monitoredServiceList.clear();
        for (int i = 0; i < monitoredServiceCollection.size(); ++i) {
            this._monitoredServiceList.add((MonitoredService)monitoredServiceCollection.get(i));
        }
    }

    public void setMonitoredServiceCollection(ArrayList monitoredServiceCollection) {
        this._monitoredServiceList = monitoredServiceCollection;
    }

    public void setSnmpPrimary(String snmpPrimary) {
        this._snmpPrimary = snmpPrimary;
    }

    public void setStatus(int status) {
        this._status = status;
        this._has_status = true;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Interface)Unmarshaller.unmarshal(Interface.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

