/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.collectd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.collectd.Mbean;
import org.xml.sax.ContentHandler;

public class Mbeans
implements Serializable {
    private ArrayList _mbeanList = new ArrayList();

    public void addMbean(Mbean vMbean) throws IndexOutOfBoundsException {
        this._mbeanList.add(vMbean);
    }

    public void addMbean(int index, Mbean vMbean) throws IndexOutOfBoundsException {
        this._mbeanList.add(index, vMbean);
    }

    public void clearMbean() {
        this._mbeanList.clear();
    }

    public Enumeration enumerateMbean() {
        return new IteratorEnumeration(this._mbeanList.iterator());
    }

    public Mbean getMbean(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._mbeanList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Mbean)this._mbeanList.get(index);
    }

    public Mbean[] getMbean() {
        int size = this._mbeanList.size();
        Mbean[] mArray = new Mbean[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Mbean)this._mbeanList.get(index);
        }
        return mArray;
    }

    public ArrayList getMbeanCollection() {
        return this._mbeanList;
    }

    public int getMbeanCount() {
        return this._mbeanList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeMbean(Mbean vMbean) {
        boolean removed = this._mbeanList.remove(vMbean);
        return removed;
    }

    public void setMbean(int index, Mbean vMbean) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._mbeanList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._mbeanList.set(index, vMbean);
    }

    public void setMbean(Mbean[] mbeanArray) {
        this._mbeanList.clear();
        for (int i = 0; i < mbeanArray.length; ++i) {
            this._mbeanList.add(mbeanArray[i]);
        }
    }

    public void setMbean(ArrayList mbeanCollection) {
        this._mbeanList.clear();
        for (int i = 0; i < mbeanCollection.size(); ++i) {
            this._mbeanList.add((Mbean)mbeanCollection.get(i));
        }
    }

    public void setMbeanCollection(ArrayList mbeanCollection) {
        this._mbeanList = mbeanCollection;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Mbeans)Unmarshaller.unmarshal(Mbeans.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

