/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.collectd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.config.collectd.Package;
import org.xml.sax.ContentHandler;

public class CollectdConfiguration
implements Serializable {
    private int _threads;
    private boolean _has_threads;
    private ArrayList _packageList = new ArrayList();
    private ArrayList _collectorList = new ArrayList();

    public void addCollector(Collector vCollector) throws IndexOutOfBoundsException {
        this._collectorList.add(vCollector);
    }

    public void addCollector(int index, Collector vCollector) throws IndexOutOfBoundsException {
        this._collectorList.add(index, vCollector);
    }

    public void addPackage(Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(vPackage);
    }

    public void addPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        this._packageList.add(index, vPackage);
    }

    public void clearCollector() {
        this._collectorList.clear();
    }

    public void clearPackage() {
        this._packageList.clear();
    }

    public void deleteThreads() {
        this._has_threads = false;
    }

    public Enumeration enumerateCollector() {
        return new IteratorEnumeration(this._collectorList.iterator());
    }

    public Enumeration enumeratePackage() {
        return new IteratorEnumeration(this._packageList.iterator());
    }

    public Collector getCollector(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._collectorList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Collector)this._collectorList.get(index);
    }

    public Collector[] getCollector() {
        int size = this._collectorList.size();
        Collector[] mArray = new Collector[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Collector)this._collectorList.get(index);
        }
        return mArray;
    }

    public ArrayList getCollectorCollection() {
        return this._collectorList;
    }

    public int getCollectorCount() {
        return this._collectorList.size();
    }

    public Package getPackage(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._packageList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Package)this._packageList.get(index);
    }

    public Package[] getPackage() {
        int size = this._packageList.size();
        Package[] mArray = new Package[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Package)this._packageList.get(index);
        }
        return mArray;
    }

    public ArrayList getPackageCollection() {
        return this._packageList;
    }

    public int getPackageCount() {
        return this._packageList.size();
    }

    public int getThreads() {
        return this._threads;
    }

    public boolean hasThreads() {
        return this._has_threads;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeCollector(Collector vCollector) {
        boolean removed = this._collectorList.remove(vCollector);
        return removed;
    }

    public boolean removePackage(Package vPackage) {
        boolean removed = this._packageList.remove(vPackage);
        return removed;
    }

    public void setCollector(int index, Collector vCollector) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._collectorList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._collectorList.set(index, vCollector);
    }

    public void setCollector(Collector[] collectorArray) {
        this._collectorList.clear();
        for (int i = 0; i < collectorArray.length; ++i) {
            this._collectorList.add(collectorArray[i]);
        }
    }

    public void setCollector(ArrayList collectorCollection) {
        this._collectorList.clear();
        for (int i = 0; i < collectorCollection.size(); ++i) {
            this._collectorList.add((Collector)collectorCollection.get(i));
        }
    }

    public void setCollectorCollection(ArrayList collectorCollection) {
        this._collectorList = collectorCollection;
    }

    public void setPackage(int index, Package vPackage) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._packageList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._packageList.set(index, vPackage);
    }

    public void setPackage(Package[] _packageArray) {
        this._packageList.clear();
        for (int i = 0; i < _packageArray.length; ++i) {
            this._packageList.add(_packageArray[i]);
        }
    }

    public void setPackage(ArrayList _packageCollection) {
        this._packageList.clear();
        for (int i = 0; i < _packageCollection.size(); ++i) {
            this._packageList.add((Package)_packageCollection.get(i));
        }
    }

    public void setPackageCollection(ArrayList _packageCollection) {
        this._packageList = _packageCollection;
    }

    public void setThreads(int threads) {
        this._threads = threads;
        this._has_threads = true;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (CollectdConfiguration)Unmarshaller.unmarshal(CollectdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

