/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.capsd;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.capsd.IpManagement;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.netmgt.config.capsd.SmbConfig;
import org.xml.sax.ContentHandler;

public class CapsdConfiguration
implements Serializable {
    private long _rescanFrequency = 0L;
    private boolean _has_rescanFrequency;
    private long _initialSleepTime = 0L;
    private boolean _has_initialSleepTime;
    private int _maxSuspectThreadPoolSize;
    private boolean _has_maxSuspectThreadPoolSize;
    private int _maxRescanThreadPoolSize;
    private boolean _has_maxRescanThreadPoolSize;
    private String _managementPolicy = "managed";
    private String _abortProtocolScansIfNoRoute = "false";
    private String _deletePropagationEnabled;
    private String _xmlrpc = "false";
    private ArrayList _protocolPluginList;
    private SmbConfig _smbConfig;
    private ArrayList _ipManagementList;

    public CapsdConfiguration() {
        this.setManagementPolicy("managed");
        this.setAbortProtocolScansIfNoRoute("false");
        this.setXmlrpc("false");
        this._protocolPluginList = new ArrayList();
        this._ipManagementList = new ArrayList();
    }

    public void addIpManagement(IpManagement vIpManagement) throws IndexOutOfBoundsException {
        this._ipManagementList.add(vIpManagement);
    }

    public void addIpManagement(int index, IpManagement vIpManagement) throws IndexOutOfBoundsException {
        this._ipManagementList.add(index, vIpManagement);
    }

    public void addProtocolPlugin(ProtocolPlugin vProtocolPlugin) throws IndexOutOfBoundsException {
        this._protocolPluginList.add(vProtocolPlugin);
    }

    public void addProtocolPlugin(int index, ProtocolPlugin vProtocolPlugin) throws IndexOutOfBoundsException {
        this._protocolPluginList.add(index, vProtocolPlugin);
    }

    public void clearIpManagement() {
        this._ipManagementList.clear();
    }

    public void clearProtocolPlugin() {
        this._protocolPluginList.clear();
    }

    public void deleteInitialSleepTime() {
        this._has_initialSleepTime = false;
    }

    public void deleteMaxRescanThreadPoolSize() {
        this._has_maxRescanThreadPoolSize = false;
    }

    public void deleteMaxSuspectThreadPoolSize() {
        this._has_maxSuspectThreadPoolSize = false;
    }

    public void deleteRescanFrequency() {
        this._has_rescanFrequency = false;
    }

    public Enumeration enumerateIpManagement() {
        return new IteratorEnumeration(this._ipManagementList.iterator());
    }

    public Enumeration enumerateProtocolPlugin() {
        return new IteratorEnumeration(this._protocolPluginList.iterator());
    }

    public String getAbortProtocolScansIfNoRoute() {
        return this._abortProtocolScansIfNoRoute;
    }

    public String getDeletePropagationEnabled() {
        return this._deletePropagationEnabled;
    }

    public long getInitialSleepTime() {
        return this._initialSleepTime;
    }

    public IpManagement getIpManagement(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._ipManagementList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (IpManagement)this._ipManagementList.get(index);
    }

    public IpManagement[] getIpManagement() {
        int size = this._ipManagementList.size();
        IpManagement[] mArray = new IpManagement[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (IpManagement)this._ipManagementList.get(index);
        }
        return mArray;
    }

    public ArrayList getIpManagementCollection() {
        return this._ipManagementList;
    }

    public int getIpManagementCount() {
        return this._ipManagementList.size();
    }

    public String getManagementPolicy() {
        return this._managementPolicy;
    }

    public int getMaxRescanThreadPoolSize() {
        return this._maxRescanThreadPoolSize;
    }

    public int getMaxSuspectThreadPoolSize() {
        return this._maxSuspectThreadPoolSize;
    }

    public ProtocolPlugin getProtocolPlugin(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._protocolPluginList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (ProtocolPlugin)this._protocolPluginList.get(index);
    }

    public ProtocolPlugin[] getProtocolPlugin() {
        int size = this._protocolPluginList.size();
        ProtocolPlugin[] mArray = new ProtocolPlugin[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (ProtocolPlugin)this._protocolPluginList.get(index);
        }
        return mArray;
    }

    public ArrayList getProtocolPluginCollection() {
        return this._protocolPluginList;
    }

    public int getProtocolPluginCount() {
        return this._protocolPluginList.size();
    }

    public long getRescanFrequency() {
        return this._rescanFrequency;
    }

    public SmbConfig getSmbConfig() {
        return this._smbConfig;
    }

    public String getXmlrpc() {
        return this._xmlrpc;
    }

    public boolean hasInitialSleepTime() {
        return this._has_initialSleepTime;
    }

    public boolean hasMaxRescanThreadPoolSize() {
        return this._has_maxRescanThreadPoolSize;
    }

    public boolean hasMaxSuspectThreadPoolSize() {
        return this._has_maxSuspectThreadPoolSize;
    }

    public boolean hasRescanFrequency() {
        return this._has_rescanFrequency;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeIpManagement(IpManagement vIpManagement) {
        boolean removed = this._ipManagementList.remove(vIpManagement);
        return removed;
    }

    public boolean removeProtocolPlugin(ProtocolPlugin vProtocolPlugin) {
        boolean removed = this._protocolPluginList.remove(vProtocolPlugin);
        return removed;
    }

    public void setAbortProtocolScansIfNoRoute(String abortProtocolScansIfNoRoute) {
        this._abortProtocolScansIfNoRoute = abortProtocolScansIfNoRoute;
    }

    public void setDeletePropagationEnabled(String deletePropagationEnabled) {
        this._deletePropagationEnabled = deletePropagationEnabled;
    }

    public void setInitialSleepTime(long initialSleepTime) {
        this._initialSleepTime = initialSleepTime;
        this._has_initialSleepTime = true;
    }

    public void setIpManagement(int index, IpManagement vIpManagement) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._ipManagementList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._ipManagementList.set(index, vIpManagement);
    }

    public void setIpManagement(IpManagement[] ipManagementArray) {
        this._ipManagementList.clear();
        for (int i = 0; i < ipManagementArray.length; ++i) {
            this._ipManagementList.add(ipManagementArray[i]);
        }
    }

    public void setIpManagement(ArrayList ipManagementCollection) {
        this._ipManagementList.clear();
        for (int i = 0; i < ipManagementCollection.size(); ++i) {
            this._ipManagementList.add((IpManagement)ipManagementCollection.get(i));
        }
    }

    public void setIpManagementCollection(ArrayList ipManagementCollection) {
        this._ipManagementList = ipManagementCollection;
    }

    public void setManagementPolicy(String managementPolicy) {
        this._managementPolicy = managementPolicy;
    }

    public void setMaxRescanThreadPoolSize(int maxRescanThreadPoolSize) {
        this._maxRescanThreadPoolSize = maxRescanThreadPoolSize;
        this._has_maxRescanThreadPoolSize = true;
    }

    public void setMaxSuspectThreadPoolSize(int maxSuspectThreadPoolSize) {
        this._maxSuspectThreadPoolSize = maxSuspectThreadPoolSize;
        this._has_maxSuspectThreadPoolSize = true;
    }

    public void setProtocolPlugin(int index, ProtocolPlugin vProtocolPlugin) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._protocolPluginList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._protocolPluginList.set(index, vProtocolPlugin);
    }

    public void setProtocolPlugin(ProtocolPlugin[] protocolPluginArray) {
        this._protocolPluginList.clear();
        for (int i = 0; i < protocolPluginArray.length; ++i) {
            this._protocolPluginList.add(protocolPluginArray[i]);
        }
    }

    public void setProtocolPlugin(ArrayList protocolPluginCollection) {
        this._protocolPluginList.clear();
        for (int i = 0; i < protocolPluginCollection.size(); ++i) {
            this._protocolPluginList.add((ProtocolPlugin)protocolPluginCollection.get(i));
        }
    }

    public void setProtocolPluginCollection(ArrayList protocolPluginCollection) {
        this._protocolPluginList = protocolPluginCollection;
    }

    public void setRescanFrequency(long rescanFrequency) {
        this._rescanFrequency = rescanFrequency;
        this._has_rescanFrequency = true;
    }

    public void setSmbConfig(SmbConfig smbConfig) {
        this._smbConfig = smbConfig;
    }

    public void setXmlrpc(String xmlrpc) {
        this._xmlrpc = xmlrpc;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (CapsdConfiguration)Unmarshaller.unmarshal(CapsdConfiguration.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

