/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.core.TreeMarshaller;
import com.thoughtworks.xstream.core.util.ObjectIdDictionary;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.path.Path;
import com.thoughtworks.xstream.io.path.PathTracker;
import com.thoughtworks.xstream.io.path.PathTrackingWriter;

public class ReferenceByXPathMarshaller
extends TreeMarshaller {
    private PathTracker pathTracker = new PathTracker();
    private ObjectIdDictionary references = new ObjectIdDictionary();

    public ReferenceByXPathMarshaller(HierarchicalStreamWriter writer, ConverterLookup converterLookup, ClassMapper classMapper) {
        super(writer, converterLookup, classMapper);
        this.writer = new PathTrackingWriter(writer, this.pathTracker);
    }

    public void convertAnother(Object item) {
        Converter converter = this.converterLookup.lookupConverterForType(item.getClass());
        if (this.classMapper.isImmutableValueType(item.getClass())) {
            converter.marshal(item, this.writer, this);
        } else {
            Path currentPath = this.pathTracker.getPath();
            Path pathOfExistingReference = (Path)this.references.lookupId(item);
            if (pathOfExistingReference != null) {
                Path absolutePath = currentPath.relativeTo(pathOfExistingReference);
                this.writer.addAttribute("reference", absolutePath.toString());
            } else {
                this.references.associateId(item, currentPath);
                converter.marshal(item, this.writer, this);
            }
        }
    }
}

