/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.joesnmp;

import java.net.InetAddress;
import org.opennms.netmgt.snmp.TrapNotification;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.snmp.TrapProcessorFactory;
import org.opennms.netmgt.snmp.joesnmp.V1TrapInformation;
import org.opennms.netmgt.snmp.joesnmp.V2TrapInformation;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpTrapHandler;
import org.opennms.protocols.snmp.SnmpTrapSession;

public class JoeSnmpTrapNotifier
implements SnmpTrapHandler {
    private TrapProcessorFactory m_trapProcessorFactory;
    private TrapNotificationListener m_listener;

    public JoeSnmpTrapNotifier(TrapNotificationListener listener, TrapProcessorFactory factory) {
        this.m_listener = listener;
        this.m_trapProcessorFactory = factory;
    }

    public void snmpReceivedTrap(SnmpTrapSession session, InetAddress agent, int port, SnmpOctetString community, SnmpPduPacket pdu) {
        this.m_listener.trapReceived((TrapNotification)new V2TrapInformation(agent, new String(community.getString()), pdu, this.m_trapProcessorFactory.createTrapProcessor()));
    }

    public void snmpReceivedTrap(SnmpTrapSession session, InetAddress agent, int port, SnmpOctetString community, SnmpPduTrap pdu) {
        this.m_listener.trapReceived((TrapNotification)new V1TrapInformation(agent, new String(community.getString()), pdu, this.m_trapProcessorFactory.createTrapProcessor()));
    }

    public void snmpTrapSessionError(SnmpTrapSession session, int error, Object ref) {
        String msg = ref != null ? ref.toString() : null;
        this.m_listener.trapError(error, msg);
    }
}

