/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.FileNotFoundException;
import javax.servlet.ServletContext;
import org.springframework.util.Log4jConfigurer;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.util.WebUtils;

public abstract class Log4jWebConfigurer {
    public static final String CONFIG_LOCATION_PARAM = "log4jConfigLocation";
    public static final String REFRESH_INTERVAL_PARAM = "log4jRefreshInterval";
    public static final String EXPOSE_WEB_APP_ROOT_PARAM = "log4jExposeWebAppRoot";

    public static void initLogging(ServletContext servletContext) {
        block8: {
            String location;
            if (Log4jWebConfigurer.exposeWebAppRoot(servletContext)) {
                WebUtils.setWebAppRootSystemProperty(servletContext);
            }
            if ((location = servletContext.getInitParameter(CONFIG_LOCATION_PARAM)) != null) {
                try {
                    if (!ResourceUtils.isUrl(location)) {
                        location = SystemPropertyUtils.resolvePlaceholders(location);
                        location = WebUtils.getRealPath(servletContext, location);
                    }
                    servletContext.log("Initializing Log4J from [" + location + "]");
                    String intervalString = servletContext.getInitParameter(REFRESH_INTERVAL_PARAM);
                    if (intervalString != null) {
                        try {
                            long refreshInterval = Long.parseLong(intervalString);
                            Log4jConfigurer.initLogging(location, refreshInterval);
                            break block8;
                        }
                        catch (NumberFormatException ex) {
                            throw new IllegalArgumentException("Invalid 'log4jRefreshInterval' parameter: " + ex.getMessage());
                        }
                    }
                    Log4jConfigurer.initLogging(location);
                }
                catch (FileNotFoundException ex) {
                    throw new IllegalArgumentException("Invalid 'log4jConfigLocation' parameter: " + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownLogging(ServletContext servletContext) {
        servletContext.log("Shutting down Log4J");
        try {
            Log4jConfigurer.shutdownLogging();
        }
        finally {
            if (Log4jWebConfigurer.exposeWebAppRoot(servletContext)) {
                WebUtils.removeWebAppRootSystemProperty(servletContext);
            }
        }
    }

    private static boolean exposeWebAppRoot(ServletContext servletContext) {
        String exposeWebAppRootParam = servletContext.getInitParameter(EXPOSE_WEB_APP_ROOT_PARAM);
        return exposeWebAppRootParam == null || Boolean.valueOf(exposeWebAppRootParam) != false;
    }
}

