/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.filter;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.filter.FilterParseException;
import org.opennms.netmgt.filter.SQLTranslation;
import org.opennms.netmgt.filter.lexer.Lexer;
import org.opennms.netmgt.filter.lexer.LexerException;
import org.opennms.netmgt.filter.node.Start;
import org.opennms.netmgt.filter.parser.Parser;
import org.opennms.netmgt.filter.parser.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filter {
    private Start m_parseTree = null;

    public void parseRule(String rule) throws FilterParseException {
        Category log = ThreadCategory.getInstance(this.getClass());
        if (rule != null && rule.length() > 0) {
            try {
                Parser p = new Parser(new Lexer(new PushbackReader(new StringReader(rule))));
                this.m_parseTree = p.parse();
            }
            catch (ParserException e) {
                log.error((Object)("Failed to parse the filter rule: " + rule), (Throwable)e);
                throw new FilterParseException("Parse error in " + rule, e);
            }
            catch (LexerException e) {
                log.error((Object)("Failed to parse filter rule: " + rule), (Throwable)e);
                throw new FilterParseException("Parse error in " + rule, e);
            }
            catch (IOException e) {
                log.error((Object)("Failed to parse filter rule: " + rule), (Throwable)e);
                throw new FilterParseException("Parse error in " + rule, e);
            }
        } else {
            throw new FilterParseException("Parse error, rule is null or empty");
        }
    }

    public Filter() {
    }

    public Filter(String rule) throws FilterParseException {
        this.parseRule(rule);
    }

    public boolean isValid(String addr, String rule) throws FilterParseException {
        if (rule.length() == 0) {
            return true;
        }
        return this.getIPList(rule).contains(addr);
    }

    public Map getIPServiceMap(String rule) {
        Category log = ThreadCategory.getInstance(this.getClass());
        TreeMap ipServices = new TreeMap();
        this.parseRule(rule);
        Connection conn = null;
        try {
            DataSourceFactory.init();
            conn = DataSourceFactory.getInstance().getConnection();
            Statement stmt = conn.createStatement();
            ResultSet rset = stmt.executeQuery(this.getIPServiceMappingStatement());
            if (rset != null) {
                while (rset.next()) {
                    Map<String, Object> services;
                    String ipaddr = rset.getString(1);
                    if (ipServices.containsKey(ipaddr)) {
                        services = (Map)ipServices.get(ipaddr);
                        services.put(rset.getString(2), null);
                        continue;
                    }
                    services = new TreeMap();
                    services.put(rset.getString(2), null);
                    ipServices.put(ipaddr, services);
                }
            }
            try {
                rset.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        catch (SQLException e) {
            log.info((Object)"SQL Exception occured getting IP List", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException ie) {
            log.fatal((Object)"IOException getting database connection", (Throwable)ie);
            throw new UndeclaredThrowableException(ie);
        }
        catch (MarshalException me) {
            log.fatal((Object)"Marshall Exception getting database connection", (Throwable)me);
            throw new UndeclaredThrowableException(me);
        }
        catch (ValidationException ve) {
            log.fatal((Object)"Validation Exception getting database connection", (Throwable)ve);
            throw new UndeclaredThrowableException(ve);
        }
        catch (PropertyVetoException ve) {
            log.fatal((Object)"Property Veto Exception getting database connection", (Throwable)ve);
            throw new UndeclaredThrowableException(ve);
        }
        catch (ClassNotFoundException e) {
            log.fatal((Object)"Class Not Found Exception getting database connection", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        return ipServices;
    }

    public List<String> getIPList(String rule) throws FilterParseException {
        Category log = ThreadCategory.getInstance(this.getClass());
        ArrayList<String> resultList = new ArrayList<String>();
        String sqlString = null;
        this.parseRule(rule);
        Connection conn = null;
        try {
            Statement stmt;
            ResultSet rset;
            DataSourceFactory.init();
            conn = DataSourceFactory.getInstance().getConnection();
            sqlString = this.getSQLStatement();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Filter: SQL statement: \n" + sqlString));
            }
            if ((rset = (stmt = conn.createStatement()).executeQuery(sqlString)) != null) {
                while (rset.next()) {
                    resultList.add(rset.getString(1));
                }
            }
            try {
                rset.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        catch (ClassNotFoundException e) {
            log.info((Object)"Class Not Found Exception occured getting IP List", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            log.info((Object)"SQL Exception occured getting IP List", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException ie) {
            log.fatal((Object)"IOException getting database connection", (Throwable)ie);
            throw new UndeclaredThrowableException(ie);
        }
        catch (MarshalException me) {
            log.fatal((Object)"Marshall Exception getting database connection", (Throwable)me);
            throw new UndeclaredThrowableException(me);
        }
        catch (ValidationException ve) {
            log.fatal((Object)"Validation Exception getting database connection", (Throwable)ve);
            throw new UndeclaredThrowableException(ve);
        }
        catch (PropertyVetoException ve) {
            log.fatal((Object)"Property Veto Exception getting database connection", (Throwable)ve);
            throw new UndeclaredThrowableException(ve);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        return resultList;
    }

    public SortedMap getNodeMap(String rule) throws FilterParseException {
        Category log = ThreadCategory.getInstance(this.getClass());
        TreeMap<Integer, String> resultMap = new TreeMap<Integer, String>();
        String sqlString = null;
        this.parseRule(rule);
        Connection conn = null;
        try {
            Statement stmt;
            ResultSet rset;
            DataSourceFactory.init();
            conn = DataSourceFactory.getInstance().getConnection();
            sqlString = this.getNodeMappingStatement();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Filter: SQL statement: \n" + sqlString));
            }
            if ((rset = (stmt = conn.createStatement()).executeQuery(sqlString)) != null) {
                while (rset.next()) {
                    resultMap.put(new Integer(rset.getInt(1)), rset.getString(2));
                }
            }
            try {
                rset.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
            try {
                stmt.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        catch (ClassNotFoundException e) {
            log.info((Object)"Class Not Found Exception occured getting node map", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            log.info((Object)"SQL Exception occured getting node map", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (IOException ie) {
            log.fatal((Object)"IOException getting database connection", (Throwable)ie);
            throw new UndeclaredThrowableException(ie);
        }
        catch (MarshalException me) {
            log.fatal((Object)"Marshall Exception getting database connection", (Throwable)me);
            throw new UndeclaredThrowableException(me);
        }
        catch (ValidationException ve) {
            log.fatal((Object)"Validation Exception getting database connection", (Throwable)ve);
            throw new UndeclaredThrowableException(ve);
        }
        catch (PropertyVetoException ve) {
            log.fatal((Object)"Property Veto Exception getting database connection", (Throwable)ve);
            throw new UndeclaredThrowableException(ve);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
        return resultMap;
    }

    public String getSQLStatement() {
        SQLTranslation translation = new SQLTranslation(this.m_parseTree);
        return translation.getStatement();
    }

    public String getSQLStatement(long nodeId, String ipaddr, String service) {
        SQLTranslation translation = new SQLTranslation(this.m_parseTree);
        translation.setConstraintTranslation(nodeId, ipaddr, service);
        return translation.getStatement();
    }

    public String getIPServiceMappingStatement() {
        SQLTranslation translation = new SQLTranslation(this.m_parseTree);
        translation.setIPServiceMappingTranslation();
        return translation.getStatement();
    }

    public String getNodeMappingStatement() {
        SQLTranslation translation = new SQLTranslation(this.m_parseTree);
        translation.setNodeMappingTranslation();
        return translation.getStatement();
    }

    public String getInterfaceWithServiceStatement() {
        SQLTranslation translation = new SQLTranslation(this.m_parseTree);
        translation.setInterfaceWithServiceTranslation();
        return translation.getStatement();
    }

    public void validateRule(String rule) throws FilterParseException {
        this.parseRule(rule);
        this.getSQLStatement();
    }

    public static List<String> getMatchingIps(String filterRules) {
        Filter filter = new Filter();
        return filter.getIPList(filterRules);
    }
}

