/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.core.utils.LazySet;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.springframework.orm.ObjectRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseTimeResourceType
implements OnmsResourceType {
    private ResourceDao m_resourceDao;
    private NodeDao m_nodeDao;

    public ResponseTimeResourceType(ResourceDao resourceDao, NodeDao nodeDao) {
        this.m_resourceDao = resourceDao;
        this.m_nodeDao = nodeDao;
    }

    public String getLabel() {
        return "Response Time";
    }

    public String getName() {
        return "responseTime";
    }

    public String getRelativePathForAttribute(String resourceParent, String resource, String attribute) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("response");
        buffer.append(File.separator);
        buffer.append(resource);
        buffer.append(File.separator);
        buffer.append(attribute);
        buffer.append(RrdFileConstants.getRrdSuffix());
        return buffer.toString();
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        return Collections.EMPTY_LIST;
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        LinkedList<OnmsResource> resources = new LinkedList<OnmsResource>();
        OnmsNode node = (OnmsNode)this.m_nodeDao.get(nodeId);
        if (node == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)nodeId, "Could not find node for node Id " + nodeId, null);
        }
        for (OnmsIpInterface i : node.getIpInterfaces()) {
            String ipAddr = i.getIpAddress();
            File iface = this.getInterfaceDirectory(ipAddr, false);
            if (!iface.isDirectory()) continue;
            resources.add(this.createResource(ipAddr));
        }
        return resources;
    }

    private File getInterfaceDirectory(String ipAddr, boolean verify) {
        File response = new File(this.m_resourceDao.getRrdDirectory(verify), "response");
        File intfDir = new File(response, ipAddr);
        if (verify && !intfDir.isDirectory()) {
            throw new ObjectRetrievalFailureException(File.class, (Object)("No interface directory exists for " + ipAddr + ": " + intfDir));
        }
        return intfDir;
    }

    private OnmsResource createResource(String intf) {
        String label = intf;
        String resource = intf;
        LazySet set = new LazySet((LazySet.Loader)new AttributeLoader(intf));
        return new OnmsResource(resource, label, (OnmsResourceType)this, (Set)set);
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return false;
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return this.getResourcesForNode(nodeId).size() > 0;
    }

    private Category log() {
        return ThreadCategory.getInstance();
    }

    public String getLinkForResource(OnmsResource resource) {
        return "element/interface.jsp?node=" + resource.getParent().getName() + "&intf=" + resource.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeLoader
    implements LazySet.Loader<OnmsAttribute> {
        private String m_intf;

        public AttributeLoader(String intf) {
            this.m_intf = intf;
        }

        public Set<OnmsAttribute> load() {
            File directory = ResponseTimeResourceType.this.getInterfaceDirectory(this.m_intf, true);
            ResponseTimeResourceType.this.log().debug((Object)("lazy-loading attributes for resource \"" + this.m_intf + "\" from directory " + directory));
            List<String> dataSources = ResourceTypeUtils.getDataSourcesInDirectory(directory);
            HashSet<OnmsAttribute> attributes = new HashSet<OnmsAttribute>(dataSources.size());
            for (String dataSource : dataSources) {
                ResponseTimeResourceType.this.log().debug((Object)("Found data source \"" + dataSource + "\" on " + this.m_intf));
                attributes.add((OnmsAttribute)new RrdGraphAttribute(dataSource));
            }
            return attributes;
        }
    }
}

