/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Category;
import org.opennms.core.utils.BundleLists;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.GraphDao;
import org.opennms.netmgt.dao.support.FileReloadCallback;
import org.opennms.netmgt.dao.support.FileReloadContainer;
import org.opennms.netmgt.model.AdhocGraphType;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.PrefabGraphType;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesGraphDao
implements GraphDao {
    public static final String DEFAULT_GRAPH_LIST_KEY = "reports";
    private Map<String, FileReloadContainer<PrefabGraphType>> m_types = new HashMap<String, FileReloadContainer<PrefabGraphType>>();
    private HashMap<String, FileReloadContainer<AdhocGraphType>> m_adhocTypes = new HashMap();
    private PrefabGraphTypeCallback m_prefabCallback = new PrefabGraphTypeCallback();
    private AdhocGraphTypeCallback m_adhocCallback = new AdhocGraphTypeCallback();

    public PropertiesGraphDao(Map<String, File> prefabConfigs, Map<String, File> adhocConfigs) throws IOException {
        this.initPrefab(prefabConfigs);
        this.initAdhoc(adhocConfigs);
    }

    private void initPrefab(Map<String, File> configMap) throws IOException {
        for (Map.Entry<String, File> configEntry : configMap.entrySet()) {
            this.loadProperties(configEntry.getKey(), configEntry.getValue());
        }
    }

    private void initAdhoc(Map<String, File> configMap) throws IOException {
        for (Map.Entry<String, File> configEntry : configMap.entrySet()) {
            this.loadAdhocProperties(configEntry.getKey(), configEntry.getValue());
        }
    }

    @Override
    public PrefabGraphType findByName(String name) {
        return this.m_types.get(name).getObject();
    }

    @Override
    public AdhocGraphType findAdhocByName(String name) {
        return this.m_adhocTypes.get(name).getObject();
    }

    public void loadProperties(String type, File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        PrefabGraphType t = this.createPrefabGraphType(type, in);
        in.close();
        this.m_types.put(t.getName(), new FileReloadContainer<PrefabGraphType>(t, file, this.m_prefabCallback));
    }

    public void loadProperties(String type, InputStream in) throws IOException {
        PrefabGraphType t = this.createPrefabGraphType(type, in);
        this.m_types.put(t.getName(), new FileReloadContainer<PrefabGraphType>(t));
    }

    private PrefabGraphType createPrefabGraphType(String type, InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        PrefabGraphType t = new PrefabGraphType();
        t.setName(type);
        t.setCommandPrefix(PropertiesGraphDao.getProperty(properties, "command.prefix"));
        t.setOutputMimeType(PropertiesGraphDao.getProperty(properties, "output.mime"));
        t.setDefaultReport(properties.getProperty("default.report", "none"));
        t.setReportMap(this.getPrefabGraphDefinitions(properties));
        return t;
    }

    public void loadAdhocProperties(String type, File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        AdhocGraphType t = this.createAdhocGraphType(type, in);
        in.close();
        this.m_adhocTypes.put(t.getName(), new FileReloadContainer<AdhocGraphType>(t, file, this.m_adhocCallback));
    }

    public void loadAdhocProperties(String type, InputStream in) throws IOException {
        AdhocGraphType t = this.createAdhocGraphType(type, in);
        this.m_adhocTypes.put(t.getName(), new FileReloadContainer<AdhocGraphType>(t));
    }

    public AdhocGraphType createAdhocGraphType(String type, InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        AdhocGraphType t = new AdhocGraphType();
        t.setName(type);
        t.setRrdDirectory(new File(PropertiesGraphDao.getProperty(properties, "command.input.dir")));
        t.setCommandPrefix(PropertiesGraphDao.getProperty(properties, "command.prefix"));
        t.setOutputMimeType(PropertiesGraphDao.getProperty(properties, "output.mime"));
        t.setTitleTemplate(PropertiesGraphDao.getProperty(properties, "adhoc.command.title"));
        t.setDataSourceTemplate(PropertiesGraphDao.getProperty(properties, "adhoc.command.ds"));
        t.setGraphLineTemplate(PropertiesGraphDao.getProperty(properties, "adhoc.command.graphline"));
        return t;
    }

    private Map<String, PrefabGraph> getPrefabGraphDefinitions(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null");
        }
        String listString = PropertiesGraphDao.getProperty(properties, DEFAULT_GRAPH_LIST_KEY);
        String[] list = BundleLists.parseBundleList((String)listString);
        LinkedHashMap<String, PrefabGraph> map = new LinkedHashMap<String, PrefabGraph>();
        for (int i = 0; i < list.length; ++i) {
            String key = list[i];
            PrefabGraph graph = PropertiesGraphDao.makePrefabGraph(key, properties, i);
            map.put(key, graph);
        }
        return map;
    }

    private static PrefabGraph makePrefabGraph(String key, Properties props, int order) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (props == null) {
            throw new IllegalArgumentException("props cannot be null");
        }
        String title = PropertiesGraphDao.getReportProperty(props, key, "name", true);
        String command = PropertiesGraphDao.getReportProperty(props, key, "command", true);
        String columnString = PropertiesGraphDao.getReportProperty(props, key, "columns", true);
        String[] columns = BundleLists.parseBundleList((String)columnString);
        String externalValuesString = PropertiesGraphDao.getReportProperty(props, key, "externalValues", false);
        String[] externalValues = externalValuesString == null ? new String[]{} : BundleLists.parseBundleList((String)externalValuesString);
        String propertiesValuesString = PropertiesGraphDao.getReportProperty(props, key, "propertiesValues", false);
        String[] propertiesValues = propertiesValuesString == null ? new String[]{} : BundleLists.parseBundleList((String)propertiesValuesString);
        String typesString = PropertiesGraphDao.getReportProperty(props, key, "type", false);
        String[] types = typesString == null ? new String[]{} : BundleLists.parseBundleList((String)typesString);
        String description = PropertiesGraphDao.getReportProperty(props, key, "description", false);
        String graphWidth = PropertiesGraphDao.getReportProperty(props, key, "width", false);
        String graphHeight = PropertiesGraphDao.getReportProperty(props, key, "height", false);
        return new PrefabGraph(key, title, columns, command, externalValues, propertiesValues, order, types, description, graphWidth, graphHeight);
    }

    private static String getProperty(Properties props, String name) {
        String property = props.getProperty(name);
        if (property == null) {
            throw new DataAccessResourceFailureException("Properties must contain '" + name + "' property");
        }
        return property;
    }

    private static String getReportProperty(Properties props, String key, String suffix, boolean required) {
        String propertyName = "report." + key + "." + suffix;
        String property = props.getProperty(propertyName);
        if (property == null && required) {
            throw new DataAccessResourceFailureException("Properties for report '" + key + "' must contain '" + propertyName + "' property");
        }
        return property;
    }

    private Category log() {
        return ThreadCategory.getInstance();
    }

    @Override
    public List<PrefabGraph> getAllPrefabGraphs() {
        LinkedList<PrefabGraph> graphs = new LinkedList<PrefabGraph>();
        for (FileReloadContainer<PrefabGraphType> container : this.m_types.values()) {
            graphs.addAll(container.getObject().getReportMap().values());
        }
        return graphs;
    }

    @Override
    public PrefabGraph getPrefabGraph(String name) {
        for (FileReloadContainer<PrefabGraphType> container : this.m_types.values()) {
            PrefabGraph graph = container.getObject().getQuery(name);
            if (graph == null) continue;
            return graph;
        }
        throw new ObjectRetrievalFailureException(PrefabGraph.class, (Object)name, "Could not find prefabricated graph report with name '" + name + "'", null);
    }

    @Override
    public PrefabGraph[] getPrefabGraphsForResource(OnmsResource resource) {
        Set attributes = resource.getAttributes();
        String resourceType = resource.getResourceType().getName();
        LinkedList<PrefabGraph> returnList = new LinkedList<PrefabGraph>();
        HashSet<String> availDataSourceList = new HashSet<String>(attributes.size());
        for (OnmsAttribute attribute : attributes) {
            availDataSourceList.add(attribute.getName());
        }
        for (PrefabGraph query : this.getAllPrefabGraphs()) {
            if (resourceType != null && !query.hasMatchingType(new String[]{resourceType})) {
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug((Object)("skipping " + query.getName() + " because its types \"" + StringUtils.arrayToDelimitedString((Object[])query.getTypes(), (String)", ") + "\" does not match resourceType \"" + resourceType + "\""));
                continue;
            }
            List<String> requiredList = Arrays.asList(query.getColumns());
            if (availDataSourceList.containsAll(requiredList)) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("adding " + query.getName() + " to query list"));
                }
                returnList.add(query);
                continue;
            }
            if (!this.log().isDebugEnabled()) continue;
            this.log().debug((Object)("not adding " + query.getName() + " to query list because the required list of attributes (" + StringUtils.collectionToDelimitedString(requiredList, (String)", ") + ") is not in the list of attributes on the resource (" + StringUtils.collectionToDelimitedString(availDataSourceList, (String)", ") + ")"));
        }
        PrefabGraph[] availQueries = returnList.toArray(new PrefabGraph[returnList.size()]);
        return availQueries;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AdhocGraphTypeCallback
    implements FileReloadCallback<AdhocGraphType> {
        private AdhocGraphTypeCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AdhocGraphType reload(AdhocGraphType object, File file) {
            AdhocGraphType adhocGraphType;
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                adhocGraphType = PropertiesGraphDao.this.createAdhocGraphType(object.getName(), in);
            }
            catch (Exception e) {
                AdhocGraphType adhocGraphType2;
                try {
                    PropertiesGraphDao.this.log().error((Object)("Could not reload configuration file '" + file.getAbsolutePath() + "' due to: " + e), (Throwable)e);
                    adhocGraphType2 = null;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                return adhocGraphType2;
            }
            IOUtils.closeQuietly((InputStream)in);
            return adhocGraphType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PrefabGraphTypeCallback
    implements FileReloadCallback<PrefabGraphType> {
        private PrefabGraphTypeCallback() {
        }

        @Override
        public PrefabGraphType reload(PrefabGraphType object, File file) {
            PrefabGraphType t;
            FileInputStream in;
            try {
                in = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                PropertiesGraphDao.this.log().error((Object)("Could not reload configuration file '" + file.getAbsolutePath() + "' due to FileNotFoundException: " + e), (Throwable)e);
                return null;
            }
            try {
                t = PropertiesGraphDao.this.createPrefabGraphType(object.getName(), in);
            }
            catch (IOException e) {
                PropertiesGraphDao.this.log().error((Object)("Could not reload configuration file '" + file.getAbsolutePath() + "' due to IOException when reading from file: " + e), (Throwable)e);
                return null;
            }
            catch (DataAccessException e) {
                PropertiesGraphDao.this.log().error((Object)("Could not reload configuration file '" + file.getAbsolutePath() + "' due to DataAccessException when reading from " + "file: " + (Object)((Object)e)), (Throwable)e);
                return null;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                PropertiesGraphDao.this.log().error((Object)("Could not reload configuration file '" + file.getAbsolutePath() + "' due to IOException when closing file: " + e), (Throwable)e);
                return null;
            }
            return t;
        }
    }
}

