/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.springframework.orm.ObjectRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSnmpResourceType
implements OnmsResourceType {
    private ResourceDao m_resourceDao;

    public NodeSnmpResourceType(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public String getName() {
        return "nodeSnmp";
    }

    public String getLabel() {
        return "SNMP Node Data";
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return this.getResourceDirectory(nodeId, false).isDirectory();
    }

    public File getResourceDirectory(int nodeId, boolean verify) {
        File snmp = new File(this.m_resourceDao.getRrdDirectory(verify), "snmp");
        File node = new File(snmp, Integer.toString(nodeId));
        if (verify && !node.isDirectory()) {
            throw new ObjectRetrievalFailureException(File.class, (Object)("No node directory exists for node " + nodeId + ": " + node));
        }
        return node;
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        List<String> dataSources = ResourceTypeUtils.getDataSourcesInDirectory(this.getResourceDirectory(nodeId, true));
        HashSet<RrdGraphAttribute> attributes = new HashSet<RrdGraphAttribute>(dataSources.size());
        for (String dataSource : dataSources) {
            attributes.add(new RrdGraphAttribute(dataSource));
        }
        OnmsResource resource = new OnmsResource("", "Node-level Performance Data", (OnmsResourceType)this, attributes);
        resources.add(resource);
        return resources;
    }

    public String getRelativePathForAttribute(String resourceParent, String resource, String attribute) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("snmp");
        buffer.append(File.separator);
        buffer.append(resourceParent);
        buffer.append(File.separator);
        buffer.append(attribute);
        buffer.append(RrdFileConstants.getRrdSuffix());
        return buffer.toString();
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return false;
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        return Collections.EMPTY_LIST;
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }
}

