/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.LazySet;
import org.opennms.core.utils.SIUtils;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceSnmpResourceType
implements OnmsResourceType {
    private ResourceDao m_resourceDao;
    private NodeDao m_nodeDao;

    public InterfaceSnmpResourceType(ResourceDao resourceDao, NodeDao nodeDao) {
        this.m_resourceDao = resourceDao;
        this.m_nodeDao = nodeDao;
    }

    public String getName() {
        return "interfaceSnmp";
    }

    public String getLabel() {
        return "SNMP Interface Data";
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return this.isResourceTypeOnParentResource(Integer.toString(nodeId));
    }

    private boolean isResourceTypeOnParentResource(String parentResource) {
        File parent = this.getParentResourceDirectory(parentResource, false);
        if (!parent.isDirectory()) {
            return false;
        }
        return parent.listFiles(RrdFileConstants.INTERFACE_DIRECTORY_FILTER).length > 0;
    }

    private File getParentResourceDirectory(String parentResource, boolean verify) {
        File snmp = new File(this.m_resourceDao.getRrdDirectory(verify), "snmp");
        File parent = new File(snmp, parentResource);
        if (verify && !parent.isDirectory()) {
            throw new ObjectRetrievalFailureException(File.class, (Object)("No parent resource directory exists for " + parentResource + ": " + parent));
        }
        return parent;
    }

    private File getResourceDirectory(String parentResource, String intf, boolean verify) {
        File parent = this.getParentResourceDirectory(parentResource, verify);
        File intfDir = new File(parent, intf);
        if (verify && !parent.isDirectory()) {
            throw new ObjectRetrievalFailureException(File.class, (Object)("No interface directory exists for " + intf + ": " + intfDir));
        }
        return intfDir;
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.get(nodeId);
        if (node == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)Integer.toString(nodeId), "Could not find node with node ID " + nodeId, null);
        }
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        File parent = this.getParentResourceDirectory(Integer.toString(nodeId), true);
        File[] intfDirs = parent.listFiles(RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        Set snmpInterfaces = node.getSnmpInterfaces();
        HashMap<String, OnmsSnmpInterface> intfMap = new HashMap<String, OnmsSnmpInterface>();
        for (OnmsSnmpInterface snmpInterface : snmpInterfaces) {
            String[] keys;
            if (snmpInterface.getIfDescr() != null && Pattern.matches(".*-cef.*", snmpInterface.getIfDescr())) continue;
            String replacedIfName = AlphaNumeric.parseAndReplace((String)snmpInterface.getIfName(), (char)'_');
            String replacedIfDescr = AlphaNumeric.parseAndReplace((String)snmpInterface.getIfDescr(), (char)'_');
            for (String key : keys = new String[]{replacedIfName + "-", replacedIfDescr + "-", replacedIfName + "-" + snmpInterface.getPhysAddr(), replacedIfDescr + "-" + snmpInterface.getPhysAddr()}) {
                if (intfMap.containsKey(key)) continue;
                intfMap.put(key, snmpInterface);
            }
        }
        for (File intfDir : intfDirs) {
            String label;
            OnmsSnmpInterface snmpInterface;
            String name;
            String key;
            String desc = name = intfDir.getName();
            String mac = "";
            int dashIndex = name.lastIndexOf("-");
            if (dashIndex >= 0) {
                desc = name.substring(0, dashIndex);
                mac = name.substring(dashIndex + 1, name.length());
            }
            if ((snmpInterface = (OnmsSnmpInterface)intfMap.get(key = desc + "-" + mac)) == null) {
                label = name + " (Not Currently Updated)";
            } else {
                StringBuffer descr = new StringBuffer();
                StringBuffer parenString = new StringBuffer();
                if (snmpInterface.getIfAlias() != null) {
                    parenString.append(snmpInterface.getIfAlias());
                }
                if (snmpInterface.getIpAddress() != null && !snmpInterface.getIpAddress().equals("0.0.0.0")) {
                    String ipaddr = snmpInterface.getIpAddress();
                    if (parenString.length() > 0) {
                        parenString.append(", ");
                    }
                    parenString.append(ipaddr);
                }
                if (snmpInterface.getIfSpeed() != null && snmpInterface.getIfSpeed() != 0L) {
                    long ifSpeed = snmpInterface.getIfSpeed();
                    String speed = SIUtils.getHumanReadableIfSpeed((long)ifSpeed);
                    if (parenString.length() > 0) {
                        parenString.append(", ");
                    }
                    parenString.append(speed);
                }
                if (snmpInterface.getIfName() != null) {
                    descr.append(snmpInterface.getIfName());
                } else if (snmpInterface.getIfDescr() != null) {
                    descr.append(snmpInterface.getIfDescr());
                } else {
                    descr.append(name);
                }
                if (parenString.length() > 0) {
                    descr.append(" (");
                    descr.append(parenString);
                    descr.append(")");
                }
                label = descr.toString();
            }
            OnmsResource resource = this.getResourceByNodeAndInterface(nodeId, intfDir.getName(), label);
            resources.add(resource);
        }
        return OnmsResource.sortIntoResourceList(resources);
    }

    private OnmsResource getResourceByNodeAndInterface(int nodeId, String intf, String label) throws DataAccessException {
        LazySet set = new LazySet((LazySet.Loader)new AttributeLoader(this.getResourceDirectory(Integer.toString(nodeId), intf, true)));
        return new OnmsResource(intf, label, (OnmsResourceType)this, (Set)set);
    }

    public String getRelativePathForAttribute(String resourceParent, String resource, String attribute) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("snmp");
        buffer.append(File.separator);
        buffer.append(resourceParent);
        buffer.append(File.separator);
        buffer.append(resource);
        buffer.append(File.separator);
        buffer.append(attribute);
        buffer.append(RrdFileConstants.getRrdSuffix());
        return buffer.toString();
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return this.getQueryableInterfacesForDomain(domain).size() > 0;
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        List<String> ifaces = this.getQueryableInterfacesForDomain(domain);
        for (String iface : ifaces) {
            resources.add(this.getResourceByDomainAndInterface(domain, iface));
        }
        return resources;
    }

    private List<String> getQueryableInterfacesForDomain(String domain) {
        if (domain == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        ArrayList<String> intfs = new ArrayList<String>();
        File snmp = new File(this.m_resourceDao.getRrdDirectory(), "snmp");
        File domainDir = new File(snmp, domain);
        if (!domainDir.exists() || !domainDir.isDirectory()) {
            throw new IllegalArgumentException("No such directory: " + domainDir);
        }
        File[] intfDirs = domainDir.listFiles(RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        if (intfDirs != null && intfDirs.length > 0) {
            intfs.ensureCapacity(intfDirs.length);
            for (int i = 0; i < intfDirs.length; ++i) {
                intfs.add(intfDirs[i].getName());
            }
        }
        return intfs;
    }

    private OnmsResource getResourceByDomainAndInterface(String domain, String intf) {
        LazySet set = new LazySet((LazySet.Loader)new AttributeLoader(this.getResourceDirectory(domain, intf, true)));
        return new OnmsResource(intf, intf, (OnmsResourceType)this, (Set)set);
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeLoader
    implements LazySet.Loader<OnmsAttribute> {
        private File m_intfDir;

        public AttributeLoader(File intfDir) {
            this.m_intfDir = intfDir;
        }

        public Set<OnmsAttribute> load() {
            List<String> dataSources = ResourceTypeUtils.getDataSourcesInDirectory(this.m_intfDir);
            HashSet<OnmsAttribute> attributes = new HashSet<OnmsAttribute>(dataSources.size());
            for (String dataSource : dataSources) {
                attributes.add((OnmsAttribute)new RrdGraphAttribute(dataSource));
            }
            return attributes;
        }
    }
}

