/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.LazySet;
import org.opennms.netmgt.config.StorageStrategy;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.dao.support.RrdFileConstants;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.springframework.orm.ObjectRetrievalFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericIndexResourceType
implements OnmsResourceType {
    private String m_name;
    private String m_label;
    private ResourceDao m_resourceDao;
    private StorageStrategy m_storageStrategy;

    public GenericIndexResourceType(ResourceDao resourceDao, String name, String label, StorageStrategy storageStrategy) {
        this.m_resourceDao = resourceDao;
        this.m_name = name;
        this.m_label = label;
        this.m_storageStrategy = storageStrategy;
    }

    public String getName() {
        return this.m_name;
    }

    public String getLabel() {
        return this.m_label;
    }

    public StorageStrategy getStorageStrategy() {
        return this.m_storageStrategy;
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return this.getResourceTypeDirectory(nodeId, false).isDirectory();
    }

    private File getResourceTypeDirectory(int nodeId, boolean verify) {
        File snmp = new File(this.m_resourceDao.getRrdDirectory(verify), "snmp");
        File node = new File(snmp, Integer.toString(nodeId));
        if (verify && !node.isDirectory()) {
            throw new ObjectRetrievalFailureException(File.class, (Object)("No node directory exists for node " + nodeId + ": " + node));
        }
        File generic = new File(node, this.getName());
        if (verify && !generic.isDirectory()) {
            throw new ObjectRetrievalFailureException(File.class, (Object)("No node directory exists for generic index " + this.getName() + ": " + generic));
        }
        return generic;
    }

    private File getResourceDirectory(int nodeId, String index) {
        return this.getResourceDirectory(nodeId, index, false);
    }

    private File getResourceDirectory(int nodeId, String index, boolean verify) {
        return new File(this.getResourceTypeDirectory(nodeId, verify), index);
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        List<String> indexes = this.getQueryableIndexesForNode(nodeId);
        for (String index : indexes) {
            resources.add(this.getResourceByNodeAndIndex(nodeId, index));
        }
        return OnmsResource.sortIntoResourceList(resources);
    }

    public List<String> getQueryableIndexesForNode(int nodeId) {
        File nodeDir = this.getResourceTypeDirectory(nodeId, true);
        LinkedList<String> indexes = new LinkedList<String>();
        File[] indexDirs = nodeDir.listFiles(RrdFileConstants.INTERFACE_DIRECTORY_FILTER);
        if (indexDirs == null) {
            return indexes;
        }
        for (File indexDir : indexDirs) {
            indexes.add(indexDir.getName());
        }
        return indexes;
    }

    public OnmsResource getResourceByNodeAndIndex(int nodeId, String index) {
        String label = index;
        LazySet set = new LazySet((LazySet.Loader)new AttributeLoader(nodeId, index));
        return new OnmsResource(index, label, (OnmsResourceType)this, (Set)set);
    }

    public String getRelativePathForAttribute(String resourceParent, String resource, String attribute) {
        return this.m_storageStrategy.getRelativePathForAttribute("snmp" + File.separator + resourceParent, resource, attribute);
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return false;
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        return Collections.EMPTY_LIST;
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AttributeLoader
    implements LazySet.Loader<OnmsAttribute> {
        private int m_nodeId;
        private String m_index;

        public AttributeLoader(int nodeId, String index) {
            this.m_nodeId = nodeId;
            this.m_index = index;
        }

        public Set<OnmsAttribute> load() {
            File resourceDirectory = GenericIndexResourceType.this.getResourceDirectory(this.m_nodeId, this.m_index);
            List<String> dataSources = ResourceTypeUtils.getDataSourcesInDirectory(resourceDirectory);
            HashSet<OnmsAttribute> attributes = new HashSet<OnmsAttribute>(dataSources.size());
            for (String dataSource : dataSources) {
                attributes.add((OnmsAttribute)new RrdGraphAttribute(dataSource));
            }
            return attributes;
        }
    }
}

