/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.support.FileReloadCallback;
import org.springframework.dao.DataAccessResourceFailureException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileReloadContainer<T> {
    private T m_object;
    private File m_file;
    private long m_lastModified;
    private FileReloadCallback<T> m_callback;

    public FileReloadContainer(T object, File file, FileReloadCallback<T> callback) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        this.m_object = object;
        this.m_file = file;
        this.m_callback = callback;
        this.m_lastModified = this.m_file.lastModified();
    }

    public FileReloadContainer(T object) {
        if (object == null) {
            throw new IllegalArgumentException("object cannot be null");
        }
        this.m_object = object;
    }

    public T getObject() throws DataAccessResourceFailureException {
        this.checkForUpdates();
        return this.m_object;
    }

    private synchronized void checkForUpdates() throws DataAccessResourceFailureException {
        T object;
        if (this.m_file == null) {
            return;
        }
        long lastModified = this.m_file.lastModified();
        if (lastModified <= this.m_lastModified) {
            return;
        }
        this.m_lastModified = lastModified;
        try {
            object = this.m_callback.reload(this.m_object, this.m_file);
        }
        catch (Throwable t) {
            String message = "Failed reloading data for object '" + this.m_object + "' from file '" + this.m_file.getAbsolutePath() + ".  Unexpected Throwable received while " + "issuing reload: " + t.getMessage();
            this.log().error((Object)message, t);
            throw new DataAccessResourceFailureException(message, t);
        }
        if (object == null) {
            this.log().info((Object)("Not updating object for file '" + this.m_file.getAbsolutePath() + "' due to reload callback returning null"));
        } else {
            this.m_object = object;
        }
    }

    public File getFile() {
        return this.m_file;
    }

    private Category log() {
        return ThreadCategory.getInstance();
    }
}

