/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.LazyList;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainResourceType
implements OnmsResourceType {
    private static final Set<OnmsAttribute> s_emptyAttributeSet = Collections.unmodifiableSet(new HashSet());
    private ResourceDao m_resourceDao;

    public DomainResourceType(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public String getLabel() {
        return "Domain";
    }

    public String getName() {
        return "domain";
    }

    public String getRelativePathForAttribute(String resourceParent, String resource, String attribute) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        throw new UnsupportedOperationException("method not implemented");
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return false;
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return false;
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }

    public OnmsResource createChildResource(String domain) {
        DomainChildResourceLoader loader = new DomainChildResourceLoader(domain);
        OnmsResource resource = new OnmsResource(domain, domain, (OnmsResourceType)this, s_emptyAttributeSet, (List)new LazyList((LazyList.Loader)loader));
        loader.setParent(resource);
        return resource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DomainChildResourceLoader
    implements LazyList.Loader<OnmsResource> {
        private String m_domain;
        private OnmsResource m_parent;

        public DomainChildResourceLoader(String domain) {
            this.m_domain = domain;
        }

        public void setParent(OnmsResource parent) {
            this.m_parent = parent;
        }

        public List<OnmsResource> load() {
            LinkedList<OnmsResource> children = new LinkedList<OnmsResource>();
            for (OnmsResourceType resourceType : this.getResourceTypesForDomain(this.m_domain)) {
                for (OnmsResource resource : resourceType.getResourcesForDomain(this.m_domain)) {
                    resource.setParent(this.m_parent);
                    children.add(resource);
                }
            }
            return children;
        }

        private Collection<OnmsResourceType> getResourceTypesForDomain(String domain) {
            LinkedList<OnmsResourceType> resourceTypes = new LinkedList<OnmsResourceType>();
            for (OnmsResourceType resourceType : DomainResourceType.this.m_resourceDao.getResourceTypes()) {
                if (!resourceType.isResourceTypeOnDomain(domain)) continue;
                resourceTypes.add(resourceType);
            }
            return resourceTypes;
        }
    }
}

