/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.netmgt.dao.OutageDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.filter.Filter;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.ServiceSelector;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutageDaoHibernate
extends AbstractDaoHibernate<OnmsOutage, Integer>
implements OutageDao {
    public OutageDaoHibernate() {
        super(OnmsOutage.class);
    }

    @Override
    public Integer currentOutageCount() {
        return this.queryInt("select count(*) from OnmsOutage as o where o.ifRegainedService is null");
    }

    @Override
    public Collection<OnmsOutage> currentOutages() {
        return this.find("from OnmsOutage as o where o.ifRegainedService is null");
    }

    @Override
    public Collection<OnmsOutage> findAll(final Integer offset, final Integer limit) {
        return (Collection)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(OnmsOutage.class).setFirstResult(offset.intValue()).setMaxResults(limit.intValue()).list();
            }
        });
    }

    @Override
    public Collection<OnmsOutage> matchingCurrentOutages(ServiceSelector selector) {
        Filter filter = new Filter();
        HashSet<String> matchingIps = new HashSet<String>(filter.getIPList(selector.getFilterRule()));
        HashSet matchingSvcs = new HashSet(selector.getServiceNames());
        LinkedList<OnmsOutage> matchingOutages = new LinkedList<OnmsOutage>();
        Collection<OnmsOutage> outages = this.currentOutages();
        for (OnmsOutage outage : outages) {
            OnmsMonitoredService svc = outage.getMonitoredService();
            if (!matchingSvcs.contains(svc.getServiceName()) && !matchingSvcs.isEmpty() || !matchingIps.contains(svc.getIpAddress())) continue;
            matchingOutages.add(outage);
        }
        return matchingOutages;
    }
}

