/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.filter.Filter;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.ServiceSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoredServiceDaoHibernate
extends AbstractDaoHibernate<OnmsMonitoredService, Integer>
implements MonitoredServiceDao {
    public MonitoredServiceDaoHibernate() {
        super(OnmsMonitoredService.class);
    }

    @Override
    public Collection<OnmsMonitoredService> findByType(String type) {
        return this.find("from OnmsMonitoredService svc where svc.serviceType.name = ?", type);
    }

    @Override
    public OnmsMonitoredService get(Integer nodeId, String ipAddress, String svcName) {
        return (OnmsMonitoredService)this.findUnique("from OnmsMonitoredService as svc where svc.ipInterface.node.id = ? and svc.ipInterface.ipAddress = ? and svc.serviceType.name = ?", nodeId, ipAddress, svcName);
    }

    @Override
    public OnmsMonitoredService get(Integer nodeId, String ipAddr, Integer ifIndex, Integer serviceId) {
        return (OnmsMonitoredService)this.findUnique("from OnmsMonitoredService as svc where svc.ipInterface.node.id = ? and svc.ipInterface.ipAddress = ? and svc.ipInterface.ifIndex = ? and svc.serviceType.id = ?", nodeId, ipAddr, ifIndex, serviceId);
    }

    @Override
    public Collection<OnmsMonitoredService> findMatchingServices(ServiceSelector selector) {
        Filter filter = new Filter();
        HashSet<String> matchingIps = new HashSet<String>(filter.getIPList(selector.getFilterRule()));
        HashSet matchingSvcs = new HashSet(selector.getServiceNames());
        LinkedList<OnmsMonitoredService> matchingServices = new LinkedList<OnmsMonitoredService>();
        List services = this.findAll();
        for (OnmsMonitoredService svc : services) {
            if (!matchingSvcs.contains(svc.getServiceName()) && !matchingSvcs.isEmpty() || !matchingIps.contains(svc.getIpAddress())) continue;
            matchingServices.add(svc);
        }
        return matchingServices;
    }

    @Override
    public Collection<OnmsMonitoredService> findByApplication(OnmsApplication application) {
        return this.find("select distinct svc from OnmsMonitoredService as svc join svc.applications a where a.name = ?", application.getName());
    }
}

