/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor.collector;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.datacollection.Collect;
import org.opennms.netmgt.config.datacollection.DatacollectionConfig;
import org.opennms.netmgt.config.datacollection.Group;
import org.opennms.netmgt.config.datacollection.Groups;
import org.opennms.netmgt.config.datacollection.IpList;
import org.opennms.netmgt.config.datacollection.MibObj;
import org.opennms.netmgt.config.datacollection.Rrd;
import org.opennms.netmgt.config.datacollection.SnmpCollection;
import org.opennms.netmgt.config.datacollection.SystemDef;
import org.opennms.netmgt.config.datacollection.SystemDefChoice;
import org.opennms.netmgt.config.datacollection.Systems;
import org.opennms.netmgt.dao.castor.collector.DataCollectionVisitor;

public class DataCollectionConfigFile {
    File m_file;

    public DataCollectionConfigFile(File file) {
        this.m_file = file;
    }

    public void visit(DataCollectionVisitor visitor) {
        DatacollectionConfig dataCollectionConfig = this.getDataCollectionConfig();
        visitor.visitDataCollectionConfig(dataCollectionConfig);
        for (SnmpCollection snmpCollection : dataCollectionConfig.getSnmpCollectionCollection()) {
            this.doVisit(snmpCollection, visitor);
        }
        visitor.completeDataCollectionConfig(dataCollectionConfig);
    }

    private void doVisit(SnmpCollection snmpCollection, DataCollectionVisitor visitor) {
        visitor.visitSnmpCollection(snmpCollection);
        this.doVisit(snmpCollection.getRrd(), visitor);
        this.doVisit(snmpCollection.getSystems(), visitor);
        this.doVisit(snmpCollection.getGroups(), visitor);
        visitor.completeSnmpCollection(snmpCollection);
    }

    private void doVisit(Groups groups, DataCollectionVisitor visitor) {
        for (Group group : groups.getGroupCollection()) {
            this.doVisit(group, visitor);
        }
    }

    private void doVisit(Group group, DataCollectionVisitor visitor) {
        visitor.visitGroup(group);
        for (MibObj mibObj : group.getMibObjCollection()) {
            this.doVisit(mibObj, visitor);
        }
        for (String subGroup : group.getIncludeGroupCollection()) {
            this.doVisitSubGroup(subGroup, visitor);
        }
        visitor.completeGroup(group);
    }

    private void doVisitSubGroup(String subGroup, DataCollectionVisitor visitor) {
        visitor.visitSubGroup(subGroup);
        visitor.completeSubGroup(subGroup);
    }

    private void doVisit(MibObj mibObj, DataCollectionVisitor visitor) {
        visitor.visitMibObj(mibObj);
        visitor.completeMibObj(mibObj);
    }

    private void doVisit(Systems systems, DataCollectionVisitor visitor) {
        for (SystemDef systemDef : systems.getSystemDefCollection()) {
            this.doVisit(systemDef, visitor);
        }
    }

    private void doVisit(SystemDef systemDef, DataCollectionVisitor visitor) {
        visitor.visitSystemDef(systemDef);
        this.doVisit(systemDef.getSystemDefChoice(), visitor);
        this.doVisit(systemDef.getIpList(), visitor);
        this.doVisit(systemDef.getCollect(), visitor);
        visitor.completeSystemDef(systemDef);
    }

    private void doVisit(Collect collect, DataCollectionVisitor visitor) {
        visitor.visitCollect(collect);
        for (String includeGroup : collect.getIncludeGroupCollection()) {
            this.doVisitIncludeGroup(includeGroup, visitor);
        }
        visitor.completeCollect(collect);
    }

    private void doVisitIncludeGroup(String includeGroup, DataCollectionVisitor visitor) {
        visitor.visitIncludeGroup(includeGroup);
        visitor.completeIncludeGroup(includeGroup);
    }

    private void doVisit(IpList ipList, DataCollectionVisitor visitor) {
        if (ipList == null) {
            return;
        }
        visitor.visitIpList(ipList);
        visitor.completeIpList(ipList);
    }

    private void doVisit(SystemDefChoice systemDefChoice, DataCollectionVisitor visitor) {
        if (systemDefChoice.getSysoid() != null) {
            this.doVisitSysOid(systemDefChoice.getSysoid(), visitor);
        }
        if (systemDefChoice.getSysoidMask() != null) {
            this.doVisitSysOidMask(systemDefChoice.getSysoidMask(), visitor);
        }
    }

    private void doVisitSysOidMask(String sysoidMask, DataCollectionVisitor visitor) {
        visitor.visitSysOidMask(sysoidMask);
        visitor.completeSysOidMask(sysoidMask);
    }

    private void doVisitSysOid(String sysoid, DataCollectionVisitor visitor) {
        visitor.visitSysOid(sysoid);
        visitor.completeSysOid(sysoid);
    }

    private void doVisit(Rrd rrd, DataCollectionVisitor visitor) {
        visitor.visitRrd(rrd);
        for (String rra : rrd.getRraCollection()) {
            this.doVisitRra(rra, visitor);
        }
        visitor.completeRrd(rrd);
    }

    private void doVisitRra(String rra, DataCollectionVisitor visitor) {
        visitor.visitRra(rra);
        visitor.completeRra(rra);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DatacollectionConfig getDataCollectionConfig() {
        FileReader in = null;
        try {
            in = new FileReader(this.m_file);
            DatacollectionConfig datacollectionConfig = (DatacollectionConfig)Unmarshaller.unmarshal(DatacollectionConfig.class, (Reader)in);
            this.closeQuietly(in);
            return datacollectionConfig;
        }
        catch (MarshalException e) {
            try {
                throw this.runtimeException("Syntax error in " + this.m_file, (Exception)((Object)e));
                catch (ValidationException e2) {
                    throw this.runtimeException("invalid attribute in " + this.m_file, (Exception)((Object)e2));
                }
                catch (FileNotFoundException e3) {
                    throw this.runtimeException("Unable to find file " + this.m_file, e3);
                }
            }
            catch (Throwable throwable) {
                this.closeQuietly(in);
                throw throwable;
            }
        }
    }

    private RuntimeException runtimeException(String msg, Exception e) {
        this.log().error((Object)msg, (Throwable)e);
        return new RuntimeException(msg, e);
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void closeQuietly(FileReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

