/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor.collector;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.log4j.Category;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.dao.castor.collector.CollectdConfigVisitor;

public class CollectdConfigFile {
    File m_file;

    public CollectdConfigFile(File file) {
        this.m_file = file;
    }

    public void visit(CollectdConfigVisitor visitor) {
        CollectdConfiguration collectdConfiguration = this.getCollectdConfiguration();
        visitor.visitCollectdConfiguration(collectdConfiguration);
        for (Collector collector : collectdConfiguration.getCollectorCollection()) {
            this.doVisit(collector, visitor);
        }
        visitor.completeCollectdConfiguration(collectdConfiguration);
    }

    private void doVisit(Collector collector, CollectdConfigVisitor visitor) {
        visitor.visitCollectorCollection(collector);
        visitor.completeCollectorCollection(collector);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CollectdConfiguration getCollectdConfiguration() {
        FileReader in = null;
        try {
            in = new FileReader(this.m_file);
            CollectdConfiguration collectdConfiguration = (CollectdConfiguration)Unmarshaller.unmarshal(CollectdConfiguration.class, (Reader)in);
            this.closeQuietly(in);
            return collectdConfiguration;
        }
        catch (MarshalException e) {
            try {
                throw this.runtimeException("Syntax error in " + this.m_file, (Exception)((Object)e));
                catch (ValidationException e2) {
                    throw this.runtimeException("invalid attribute in " + this.m_file, (Exception)((Object)e2));
                }
                catch (FileNotFoundException e3) {
                    throw this.runtimeException("Unable to find file " + this.m_file, e3);
                }
            }
            catch (Throwable throwable) {
                this.closeQuietly(in);
                throw throwable;
            }
        }
    }

    private RuntimeException runtimeException(String msg, Exception e) {
        this.log().error((Object)msg, (Throwable)e);
        return new RuntimeException(msg, e);
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    private void closeQuietly(FileReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

