/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.filter;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.filter.Column;
import org.opennms.netmgt.config.filter.Join;
import org.xml.sax.ContentHandler;

public class Table
implements Serializable {
    private String _visable = "true";
    private String _name;
    private String _key = "secondary";
    private ArrayList _columnList;
    private ArrayList _joinList;

    public Table() {
        this.setVisable("true");
        this.setKey("secondary");
        this._columnList = new ArrayList();
        this._joinList = new ArrayList();
    }

    public void addColumn(Column vColumn) throws IndexOutOfBoundsException {
        this._columnList.add(vColumn);
    }

    public void addColumn(int index, Column vColumn) throws IndexOutOfBoundsException {
        this._columnList.add(index, vColumn);
    }

    public void addJoin(Join vJoin) throws IndexOutOfBoundsException {
        this._joinList.add(vJoin);
    }

    public void addJoin(int index, Join vJoin) throws IndexOutOfBoundsException {
        this._joinList.add(index, vJoin);
    }

    public void clearColumn() {
        this._columnList.clear();
    }

    public void clearJoin() {
        this._joinList.clear();
    }

    public Enumeration enumerateColumn() {
        return new IteratorEnumeration(this._columnList.iterator());
    }

    public Enumeration enumerateJoin() {
        return new IteratorEnumeration(this._joinList.iterator());
    }

    public Column getColumn(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._columnList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Column)this._columnList.get(index);
    }

    public Column[] getColumn() {
        int size = this._columnList.size();
        Column[] mArray = new Column[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Column)this._columnList.get(index);
        }
        return mArray;
    }

    public ArrayList getColumnCollection() {
        return this._columnList;
    }

    public int getColumnCount() {
        return this._columnList.size();
    }

    public Join getJoin(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._joinList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Join)this._joinList.get(index);
    }

    public Join[] getJoin() {
        int size = this._joinList.size();
        Join[] mArray = new Join[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Join)this._joinList.get(index);
        }
        return mArray;
    }

    public ArrayList getJoinCollection() {
        return this._joinList;
    }

    public int getJoinCount() {
        return this._joinList.size();
    }

    public String getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public String getVisable() {
        return this._visable;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeColumn(Column vColumn) {
        boolean removed = this._columnList.remove(vColumn);
        return removed;
    }

    public boolean removeJoin(Join vJoin) {
        boolean removed = this._joinList.remove(vJoin);
        return removed;
    }

    public void setColumn(int index, Column vColumn) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._columnList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._columnList.set(index, vColumn);
    }

    public void setColumn(Column[] columnArray) {
        this._columnList.clear();
        for (int i = 0; i < columnArray.length; ++i) {
            this._columnList.add(columnArray[i]);
        }
    }

    public void setColumn(ArrayList columnCollection) {
        this._columnList.clear();
        for (int i = 0; i < columnCollection.size(); ++i) {
            this._columnList.add((Column)columnCollection.get(i));
        }
    }

    public void setColumnCollection(ArrayList columnCollection) {
        this._columnList = columnCollection;
    }

    public void setJoin(int index, Join vJoin) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._joinList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._joinList.set(index, vJoin);
    }

    public void setJoin(Join[] joinArray) {
        this._joinList.clear();
        for (int i = 0; i < joinArray.length; ++i) {
            this._joinList.add(joinArray[i]);
        }
    }

    public void setJoin(ArrayList joinCollection) {
        this._joinList.clear();
        for (int i = 0; i < joinCollection.size(); ++i) {
            this._joinList.add((Join)joinCollection.get(i));
        }
    }

    public void setJoinCollection(ArrayList joinCollection) {
        this._joinList = joinCollection;
    }

    public void setKey(String key) {
        this._key = key;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setVisable(String visable) {
        this._visable = visable;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Table)Unmarshaller.unmarshal(Table.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

