/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.filter;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.filter.Table;
import org.xml.sax.ContentHandler;

public class DatabaseSchema
implements Serializable {
    private ArrayList _tableList = new ArrayList();

    public void addTable(Table vTable) throws IndexOutOfBoundsException {
        this._tableList.add(vTable);
    }

    public void addTable(int index, Table vTable) throws IndexOutOfBoundsException {
        this._tableList.add(index, vTable);
    }

    public void clearTable() {
        this._tableList.clear();
    }

    public Enumeration enumerateTable() {
        return new IteratorEnumeration(this._tableList.iterator());
    }

    public Table getTable(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._tableList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Table)this._tableList.get(index);
    }

    public Table[] getTable() {
        int size = this._tableList.size();
        Table[] mArray = new Table[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Table)this._tableList.get(index);
        }
        return mArray;
    }

    public ArrayList getTableCollection() {
        return this._tableList;
    }

    public int getTableCount() {
        return this._tableList.size();
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeTable(Table vTable) {
        boolean removed = this._tableList.remove(vTable);
        return removed;
    }

    public void setTable(int index, Table vTable) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._tableList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._tableList.set(index, vTable);
    }

    public void setTable(Table[] tableArray) {
        this._tableList.clear();
        for (int i = 0; i < tableArray.length; ++i) {
            this._tableList.add(tableArray[i]);
        }
    }

    public void setTable(ArrayList tableCollection) {
        this._tableList.clear();
        for (int i = 0; i < tableCollection.size(); ++i) {
            this._tableList.add((Table)tableCollection.get(i));
        }
    }

    public void setTableCollection(ArrayList tableCollection) {
        this._tableList = tableCollection;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (DatabaseSchema)Unmarshaller.unmarshal(DatabaseSchema.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

