/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.filter;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import org.exolab.castor.util.IteratorEnumeration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.opennms.netmgt.config.filter.Alias;
import org.opennms.netmgt.config.filter.Constraint;
import org.xml.sax.ContentHandler;

public class Column
implements Serializable {
    private String _name;
    private String _sqlType;
    private String _javaType;
    private String _visable = "true";
    private ArrayList _aliasList;
    private ArrayList _constraintList;

    public Column() {
        this.setVisable("true");
        this._aliasList = new ArrayList();
        this._constraintList = new ArrayList();
    }

    public void addAlias(Alias vAlias) throws IndexOutOfBoundsException {
        this._aliasList.add(vAlias);
    }

    public void addAlias(int index, Alias vAlias) throws IndexOutOfBoundsException {
        this._aliasList.add(index, vAlias);
    }

    public void addConstraint(Constraint vConstraint) throws IndexOutOfBoundsException {
        this._constraintList.add(vConstraint);
    }

    public void addConstraint(int index, Constraint vConstraint) throws IndexOutOfBoundsException {
        this._constraintList.add(index, vConstraint);
    }

    public void clearAlias() {
        this._aliasList.clear();
    }

    public void clearConstraint() {
        this._constraintList.clear();
    }

    public Enumeration enumerateAlias() {
        return new IteratorEnumeration(this._aliasList.iterator());
    }

    public Enumeration enumerateConstraint() {
        return new IteratorEnumeration(this._constraintList.iterator());
    }

    public Alias getAlias(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._aliasList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Alias)this._aliasList.get(index);
    }

    public Alias[] getAlias() {
        int size = this._aliasList.size();
        Alias[] mArray = new Alias[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Alias)this._aliasList.get(index);
        }
        return mArray;
    }

    public ArrayList getAliasCollection() {
        return this._aliasList;
    }

    public int getAliasCount() {
        return this._aliasList.size();
    }

    public Constraint getConstraint(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._constraintList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (Constraint)this._constraintList.get(index);
    }

    public Constraint[] getConstraint() {
        int size = this._constraintList.size();
        Constraint[] mArray = new Constraint[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (Constraint)this._constraintList.get(index);
        }
        return mArray;
    }

    public ArrayList getConstraintCollection() {
        return this._constraintList;
    }

    public int getConstraintCount() {
        return this._constraintList.size();
    }

    public String getJavaType() {
        return this._javaType;
    }

    public String getName() {
        return this._name;
    }

    public String getSqlType() {
        return this._sqlType;
    }

    public String getVisable() {
        return this._visable;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeAlias(Alias vAlias) {
        boolean removed = this._aliasList.remove(vAlias);
        return removed;
    }

    public boolean removeConstraint(Constraint vConstraint) {
        boolean removed = this._constraintList.remove(vConstraint);
        return removed;
    }

    public void setAlias(int index, Alias vAlias) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._aliasList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._aliasList.set(index, vAlias);
    }

    public void setAlias(Alias[] aliasArray) {
        this._aliasList.clear();
        for (int i = 0; i < aliasArray.length; ++i) {
            this._aliasList.add(aliasArray[i]);
        }
    }

    public void setAlias(ArrayList aliasCollection) {
        this._aliasList.clear();
        for (int i = 0; i < aliasCollection.size(); ++i) {
            this._aliasList.add((Alias)aliasCollection.get(i));
        }
    }

    public void setAliasCollection(ArrayList aliasCollection) {
        this._aliasList = aliasCollection;
    }

    public void setConstraint(int index, Constraint vConstraint) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._constraintList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._constraintList.set(index, vConstraint);
    }

    public void setConstraint(Constraint[] constraintArray) {
        this._constraintList.clear();
        for (int i = 0; i < constraintArray.length; ++i) {
            this._constraintList.add(constraintArray[i]);
        }
    }

    public void setConstraint(ArrayList constraintCollection) {
        this._constraintList.clear();
        for (int i = 0; i < constraintCollection.size(); ++i) {
            this._constraintList.add((Constraint)constraintCollection.get(i));
        }
    }

    public void setConstraintCollection(ArrayList constraintCollection) {
        this._constraintList = constraintCollection;
    }

    public void setJavaType(String javaType) {
        this._javaType = javaType;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setSqlType(String sqlType) {
        this._sqlType = sqlType;
    }

    public void setVisable(String visable) {
        this._visable = visable;
    }

    public static Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Column)Unmarshaller.unmarshal(Column.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

