/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Category;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.jdo.conf.Driver;
import org.exolab.castor.jdo.conf.Jndi;
import org.exolab.castor.jdo.conf.Mapping;
import org.exolab.castor.jdo.conf.Param;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.ClosableDataSource;
import org.xml.sax.InputSource;

public final class LegacyDatabaseConnectionFactory
implements ClosableDataSource {
    private static final int MAX_AGE = 300000;
    private static DataSource m_singleton = null;
    private static boolean m_loaded = false;
    private Database m_database = null;
    private String m_driverUrl;
    private String m_driverUser;
    private String m_driverPass;
    private LinkedList m_dbcCache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LegacyDatabaseConnectionFactory(String configFile) throws IOException, MarshalException, ValidationException, ClassNotFoundException {
        Class<Database> dsc = Database.class;
        FileInputStream fileInputStream = new FileInputStream(configFile);
        try {
            InputSource dbIn = new InputSource(fileInputStream);
            dbIn.setSystemId(configFile);
            this.m_database = (Database)Unmarshaller.unmarshal(dsc, (InputSource)dbIn);
            this.m_dbcCache = new LinkedList();
            Param[] parms = this.m_database.getDatabaseChoice().getDriver().getParam();
            for (int i = 0; i < parms.length; ++i) {
                if (parms[i].getName().equals("user")) {
                    this.m_driverUser = parms[i].getValue();
                    continue;
                }
                if (!parms[i].getName().equals("password")) continue;
                this.m_driverPass = parms[i].getValue();
            }
            this.m_driverUrl = this.m_database.getDatabaseChoice().getDriver().getUrl();
            String driverCN = this.m_database.getDatabaseChoice().getDriver().getClassName();
            Class.forName(driverCN);
        }
        finally {
            fileInputStream.close();
        }
    }

    public static synchronized void init() throws IOException, MarshalException, ValidationException, ClassNotFoundException {
        if (m_loaded) {
            return;
        }
        File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.DB_CONFIG_FILE_NAME);
        m_singleton = new LegacyDatabaseConnectionFactory(cfgFile.getPath());
        m_loaded = true;
    }

    public static synchronized DataSource getInstance() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public static void setInstance(DataSource singleton) {
        m_singleton = singleton;
        m_loaded = true;
    }

    public Database getDatabase() {
        return this.m_database;
    }

    public static synchronized DataSource getDataSource() {
        if (!m_loaded) {
            throw new IllegalStateException("The factory has not been initialized");
        }
        return m_singleton;
    }

    public Driver getDriver() {
        return this.m_database.getDatabaseChoice().getDriver();
    }

    public String getEngine() {
        return this.m_database.getEngine();
    }

    public Jndi getJndi() {
        return this.m_database.getDatabaseChoice().getJndi();
    }

    public Mapping[] getMapping() {
        return this.m_database.getMapping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        LinkedList linkedList = this.m_dbcCache;
        synchronized (linkedList) {
            Category log = ThreadCategory.getInstance(this.getClass());
            boolean isTracing = log.isDebugEnabled();
            CachedConnection cdbc = null;
            while (cdbc == null && !this.m_dbcCache.isEmpty()) {
                CachedConnection cachedConnection = cdbc = (CachedConnection)this.m_dbcCache.removeFirst();
                synchronized (cachedConnection) {
                    if (cdbc.isAvailable() && cdbc.isBad()) {
                        if (isTracing) {
                            log.debug((Object)("removed bad connection from pool [id=" + cdbc + "]"));
                        }
                        continue;
                    }
                    if (cdbc.isAvailable()) {
                        cdbc.markUsed();
                        if (isTracing) {
                            log.debug((Object)("reusing previous connection [id=" + cdbc + "]"));
                        }
                    }
                }
                if (this.m_dbcCache.isEmpty()) continue;
                long age = ((CachedConnection)this.m_dbcCache.getLast()).age();
                if (age >= 300000L) {
                    CachedConnection disconnect = (CachedConnection)this.m_dbcCache.removeLast();
                    if (isTracing) {
                        log.debug((Object)("removing expired connection [id=" + disconnect + "]"));
                    }
                    try {
                        disconnect.m_delegate.close();
                    }
                    catch (SQLException e) {
                        if (!isTracing) continue;
                        log.debug((Object)"An error occured closing delegate", (Throwable)e);
                    }
                    continue;
                }
                if (!isTracing) continue;
                log.debug((Object)("stack bottom is " + age + "ms old"));
                log.debug((Object)("stack size is " + this.m_dbcCache.size()));
            }
            if (cdbc == null) {
                cdbc = new CachedConnection(DriverManager.getConnection(this.m_driverUrl, this.m_driverUser, this.m_driverPass), this);
                cdbc.markUsed();
                if (isTracing) {
                    log.debug((Object)"created new JDBC connection, no previous reference available");
                }
            }
            return cdbc;
        }
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    public void close() throws SQLException {
    }

    static final class CachedConnection
    implements Connection {
        private final Connection m_delegate;
        private final LegacyDatabaseConnectionFactory m_owner;
        private boolean m_inUse;
        private boolean m_hadError;
        private long m_lastUse;

        CachedConnection(Connection dbc, LegacyDatabaseConnectionFactory owner) {
            this.m_delegate = dbc;
            this.m_owner = owner;
            this.m_inUse = false;
            this.m_hadError = false;
            this.m_lastUse = System.currentTimeMillis();
        }

        private synchronized void checkAccess() throws SQLException {
            if (!this.m_inUse) {
                ThreadCategory.getInstance(this.getClass()).warn((Object)"Attempting to used closed connection", new Throwable());
                throw new SQLException("The connection has already been closed");
            }
        }

        synchronized boolean isAvailable() {
            return !this.m_inUse;
        }

        synchronized void markUsed() {
            this.m_inUse = true;
        }

        synchronized boolean isBad() {
            return this.m_hadError;
        }

        synchronized long age() {
            return System.currentTimeMillis() - this.m_lastUse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close() throws SQLException {
            Category log = ThreadCategory.getInstance(this.getClass());
            boolean isTracing = log.isDebugEnabled();
            if (!this.m_inUse) {
                log.warn((Object)"The in use flag was not set but the connection is being closed!", new Throwable());
            }
            try {
                if (!this.m_delegate.getAutoCommit()) {
                    this.m_delegate.setAutoCommit(true);
                }
                if (this.m_delegate.isReadOnly()) {
                    if (isTracing) {
                        log.debug((Object)"connection is read-only, setting bad flag");
                    }
                    this.m_hadError = true;
                }
                if (this.m_delegate.isClosed()) {
                    if (isTracing) {
                        log.debug((Object)"connection is closed, setting bad flag");
                    }
                    this.m_hadError = true;
                }
            }
            catch (SQLException ex) {
                if (isTracing) {
                    log.debug((Object)"setting bad flag true", (Throwable)ex);
                }
                this.m_hadError = true;
            }
            this.m_inUse = false;
            if (this.m_hadError) {
                this.m_delegate.close();
            } else {
                LinkedList linkedList = this.m_owner.m_dbcCache;
                synchronized (linkedList) {
                    if (isTracing) {
                        log.debug((Object)("adding connection back into pool [id=" + this + "]"));
                    }
                    this.m_owner.m_dbcCache.addFirst(this);
                }
                this.m_lastUse = System.currentTimeMillis();
            }
        }

        public synchronized boolean isClosed() throws SQLException {
            try {
                if (this.m_inUse) {
                    return this.m_delegate.isClosed();
                }
                return true;
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public Statement createStatement() throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.createStatement();
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.prepareStatement(sql);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.prepareStatement(sql, autoGeneratedKeys);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.prepareStatement(sql, columnIndexes);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.prepareStatement(sql, columnNames);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public CallableStatement prepareCall(String sql) throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.prepareCall(sql);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public String nativeSQL(String sql) throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.nativeSQL(sql);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.checkAccess();
            try {
                this.m_delegate.setAutoCommit(autoCommit);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public boolean getAutoCommit() throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.getAutoCommit();
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public void commit() throws SQLException {
            this.checkAccess();
            try {
                this.m_delegate.commit();
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public void rollback() throws SQLException {
            this.checkAccess();
            try {
                this.m_delegate.rollback();
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public void rollback(Savepoint savepoint) throws SQLException {
            this.checkAccess();
            try {
                this.m_delegate.rollback(savepoint);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.getMetaData();
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public void setReadOnly(boolean readOnly) throws SQLException {
            this.checkAccess();
            try {
                this.m_delegate.setReadOnly(readOnly);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public boolean isReadOnly() throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.isReadOnly();
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public void setCatalog(String catalog) throws SQLException {
            this.checkAccess();
            try {
                this.m_delegate.setCatalog(catalog);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public String getCatalog() throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.getCatalog();
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public void setTransactionIsolation(int level) throws SQLException {
            this.checkAccess();
            try {
                this.m_delegate.setTransactionIsolation(level);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public int getTransactionIsolation() throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.getTransactionIsolation();
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public SQLWarning getWarnings() throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.getWarnings();
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public void clearWarnings() throws SQLException {
            this.checkAccess();
            try {
                this.m_delegate.clearWarnings();
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.createStatement(resultSetType, resultSetConcurrency);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.prepareCall(sql, resultSetType, resultSetConcurrency);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public Map getTypeMap() throws SQLException {
            this.checkAccess();
            try {
                return this.m_delegate.getTypeMap();
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public void setTypeMap(Map map) throws SQLException {
            this.checkAccess();
            try {
                this.m_delegate.setTypeMap(map);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public String toString() {
            return this.m_delegate.toString();
        }

        public int getHoldability() throws SQLException {
            try {
                return this.m_delegate.getHoldability();
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public void setHoldability(int holdability) throws SQLException {
            try {
                this.m_delegate.setHoldability(holdability);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public Savepoint setSavepoint() throws SQLException {
            try {
                return this.m_delegate.setSavepoint();
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public Savepoint setSavepoint(String name) throws SQLException {
            try {
                return this.m_delegate.setSavepoint(name);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }

        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            try {
                this.m_delegate.releaseSavepoint(savepoint);
            }
            catch (SQLException ex) {
                this.m_hadError = true;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("setting bad flag [id=" + this + "]"), (Throwable)ex);
                throw ex;
            }
        }
    }
}

