/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.exolab.castor.jdo.conf.Database;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.ConfigFileConstants;
import org.opennms.netmgt.config.C3P0ConnectionFactory;
import org.opennms.netmgt.config.ClosableDataSource;
import org.opennms.netmgt.config.LegacyDatabaseConnectionFactory;

public final class DataSourceFactory
implements DataSource {
    private static DataSource m_singleton = null;
    private static boolean m_legacy = false;
    private static Map<String, DataSource> m_dataSources = new HashMap<String, DataSource>();
    private Database m_database = null;

    public static synchronized void init() throws IOException, MarshalException, ValidationException, ClassNotFoundException, PropertyVetoException, SQLException {
        if (DataSourceFactory.isLoaded("opennms")) {
            return;
        }
        DataSourceFactory.init("opennms");
    }

    public static synchronized void init(String dsName) throws IOException, MarshalException, ValidationException, ClassNotFoundException, PropertyVetoException, SQLException {
        if (DataSourceFactory.isLoaded(dsName)) {
            return;
        }
        File cfgFile = ConfigFileConstants.getConfigFileByName((String)(dsName + "-database.xml"));
        ClosableDataSource dataSource = null;
        dataSource = !DataSourceFactory.isLegacy() ? new C3P0ConnectionFactory(cfgFile.getPath()) : new LegacyDatabaseConnectionFactory(cfgFile.getPath());
        DataSourceFactory.setInstance(dsName, dataSource);
    }

    public static boolean isLegacy() {
        return m_legacy;
    }

    public static void setLegacy(boolean legacy) {
        m_legacy = legacy;
    }

    private static boolean isLoaded(String dsName) {
        return m_dataSources.containsKey(dsName);
    }

    public static synchronized DataSource getInstance() {
        return DataSourceFactory.getInstance("opennms");
    }

    public static synchronized DataSource getInstance(String name) {
        DataSource dataSource = m_dataSources.get(name);
        if (dataSource == null) {
            throw new IllegalArgumentException("Unable to locate data source named " + name + ".  Does this need to be init'd?");
        }
        return m_dataSources.get(name);
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection("opennms");
    }

    public Connection getConnection(String dsName) throws SQLException {
        return m_dataSources.get(dsName).getConnection();
    }

    public static void setInstance(DataSource singleton) {
        m_singleton = singleton;
        DataSourceFactory.setInstance("opennms", singleton);
    }

    public static void setInstance(String dsName, DataSource singleton) {
        m_dataSources.put(dsName, singleton);
    }

    public Database getDatabase() {
        return this.m_database;
    }

    public static DataSource getDataSource() {
        return DataSourceFactory.getDataSource("opennms");
    }

    public static DataSource getDataSource(String dsName) {
        return m_dataSources.get(dsName);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.getConnection();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return m_singleton.getLogWriter();
    }

    public PrintWriter getLogWriter(String dsName) throws SQLException {
        return m_dataSources.get(dsName).getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.setLogWriter("opennms", out);
    }

    public void setLogWriter(String dsName, PrintWriter out) throws SQLException {
        m_dataSources.get(dsName).setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.setLoginTimeout("opennms", seconds);
    }

    public void setLoginTimeout(String dsName, int seconds) throws SQLException {
        m_dataSources.get(dsName).setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getLoginTimeout("opennms");
    }

    public int getLoginTimeout(String dsName) throws SQLException {
        return m_dataSources.get(dsName).getLoginTimeout();
    }

    public void initialize() throws MarshalException, ValidationException, IOException, ClassNotFoundException {
    }

    public static synchronized void close() throws SQLException {
        for (DataSource dataSource : m_dataSources.values()) {
            if (!(dataSource instanceof ClosableDataSource)) continue;
            ((ClosableDataSource)dataSource).close();
        }
        m_dataSources.clear();
    }
}

