/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import org.opennms.netmgt.config.CollectdPackage;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectdConfig {
    private CollectdConfiguration m_config;
    private Collection<CollectdPackage> m_packages;

    protected CollectdConfig(CollectdConfiguration config, String localServer, boolean verifyServer) {
        this.m_config = config;
        this.createPackageObjects(localServer, verifyServer);
        this.initialize(localServer, verifyServer);
    }

    private void createPackageObjects(String localServer, boolean verifyServer) {
        this.m_packages = new LinkedList<CollectdPackage>();
        Enumeration pkgEnum = this.m_config.enumeratePackage();
        while (pkgEnum.hasMoreElements()) {
            Package pkg = (Package)pkgEnum.nextElement();
            this.m_packages.add(new CollectdPackage(pkg, localServer, verifyServer));
        }
    }

    public CollectdConfiguration getConfig() {
        return this.m_config;
    }

    public Collection<CollectdPackage> getPackages() {
        return this.m_packages;
    }

    public int getThreads() {
        return this.m_config.getThreads();
    }

    protected void createPackageIpListMap(String localServer, boolean verifyServer) {
        for (CollectdPackage wpkg : this.getPackages()) {
            wpkg.createIpList(localServer, verifyServer);
        }
    }

    protected void initialize(String localServer, boolean verifyServer) {
        this.createPackageIpListMap(localServer, verifyServer);
    }

    public CollectdPackage getPackage(String name) {
        for (CollectdPackage wpkg : this.getPackages()) {
            if (!wpkg.getName().equals(name)) continue;
            return wpkg;
        }
        return null;
    }

    public boolean domainExists(String name) {
        for (CollectdPackage wpkg : this.getPackages()) {
            if (wpkg.ifAliasDomain() == null || !wpkg.ifAliasDomain().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isServiceCollectionEnabled(String ipAddr, String svcName) {
        boolean result = false;
        for (CollectdPackage wpkg : this.getPackages()) {
            if (!wpkg.interfaceInPackage(ipAddr) || !wpkg.serviceInPackageAndEnabled(svcName)) continue;
            result = true;
        }
        return result;
    }
}

