/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.SnmpInterfaceBuilder;

public class NetworkBuilder {
    OnmsDistPoller m_distPoller;
    OnmsNode m_currentNode;
    OnmsIpInterface m_currentIf;
    OnmsMonitoredService m_currentMonSvc;

    public NetworkBuilder(OnmsDistPoller distPoller) {
        this.m_distPoller = distPoller;
    }

    public NodeBuilder addNode(String label) {
        this.m_currentNode = new OnmsNode(this.m_distPoller);
        this.m_currentNode.setLabel(label);
        return new NodeBuilder(this.m_currentNode);
    }

    public InterfaceBuilder addInterface(String ipAddr) {
        this.m_currentIf = new OnmsIpInterface(ipAddr, this.m_currentNode);
        return new InterfaceBuilder(this.m_currentIf);
    }

    public InterfaceBuilder addInterface(String ipAddr, OnmsSnmpInterface snmpInterface) {
        this.m_currentIf = new OnmsIpInterface(ipAddr, this.m_currentNode);
        this.m_currentIf.setSnmpInterface(snmpInterface);
        return new InterfaceBuilder(this.m_currentIf);
    }

    public SnmpInterfaceBuilder addSnmpInterface(String ipAddr, int ifIndex) {
        OnmsSnmpInterface snmpIf = new OnmsSnmpInterface(ipAddr, ifIndex, this.m_currentNode);
        return new SnmpInterfaceBuilder(snmpIf);
    }

    public OnmsMonitoredService addService(OnmsServiceType serviceType) {
        this.m_currentMonSvc = new OnmsMonitoredService(this.m_currentIf, serviceType);
        return this.m_currentMonSvc;
    }

    public void setDisplayCategory(String displayCategory) {
        this.m_currentNode.getAssetRecord().setDisplayCategory(displayCategory);
    }

    public OnmsNode getCurrentNode() {
        return this.m_currentNode;
    }

    public class InterfaceBuilder {
        OnmsIpInterface m_iface;

        InterfaceBuilder(OnmsIpInterface iface) {
            this.m_iface = iface;
        }

        public InterfaceBuilder setIsManaged(String managed) {
            this.m_iface.setIsManaged(managed);
            return this;
        }

        public InterfaceBuilder setIsSnmpPrimary(String isSnmpPrimary) {
            this.m_iface.setIsSnmpPrimary(OnmsIpInterface.CollectionType.get(isSnmpPrimary));
            return this;
        }

        public OnmsIpInterface getInterface() {
            return this.m_iface;
        }

        public InterfaceBuilder setIpStatus(int ipStatus) {
            this.m_iface.setIpStatus(new Integer(ipStatus));
            return this;
        }

        public SnmpInterfaceBuilder addSnmpInterface(String ipAddr, int ifIndex) {
            OnmsSnmpInterface snmpIf = new OnmsSnmpInterface(ipAddr, ifIndex, NetworkBuilder.this.m_currentNode);
            this.m_iface.setSnmpInterface(snmpIf);
            return new SnmpInterfaceBuilder(snmpIf);
        }

        public InterfaceBuilder setId(int id) {
            this.m_iface.setId(id);
            return this;
        }
    }

    public class NodeBuilder {
        OnmsNode m_node;

        NodeBuilder(OnmsNode node) {
            this.m_node = node;
        }

        public OnmsNode getNode() {
            return this.m_node;
        }

        public NodeBuilder setId(Integer id) {
            this.m_node.setId(id);
            return this;
        }

        public NodeBuilder setForeignSource(String foreignSource) {
            this.m_node.setForeignSource(foreignSource);
            return this;
        }

        public NodeBuilder setForeignId(String foreignId) {
            this.m_node.setForeignId(foreignId);
            return this;
        }

        public OnmsAssetRecord getAssetRecord() {
            return this.m_node.getAssetRecord();
        }
    }
}

