/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.rrd.QueuingRrdStrategy;
import org.opennms.netmgt.rrd.RrdConfig;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdStrategy;

public class RrdUtils {
    private static final String DEFAULT_RRD_STRATEGY_CLASSNAME = "org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy";
    private static final boolean USE_QUEUE = RrdConfig.getProperty("org.opennms.rrd.usequeue", true);
    private static final String RRD_STRATEGY_CLASSNAME = RrdConfig.getProperty("org.opennms.rrd.strategyClass", "org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy");
    private static RrdStrategy m_rrdStrategy = null;
    private static String m_rrdExtension = RrdConfig.getProperty("org.opennms.rrd.fileExtension", null);

    public static RrdStrategy getStrategy() {
        if (m_rrdStrategy == null) {
            throw new IllegalStateException("RrdUtils not initiailzed");
        }
        return m_rrdStrategy;
    }

    public static void setStrategy(RrdStrategy strategy) {
        m_rrdStrategy = strategy;
    }

    public static void initialize() throws RrdException {
        try {
            RrdUtils.createStrategy();
            m_rrdStrategy.initialize();
        }
        catch (Exception e) {
            throw new RrdException("An error occured initializing the Rrd subsytem", e);
        }
    }

    public static void graphicsInitialize() throws RrdException {
        try {
            RrdUtils.createStrategy();
            m_rrdStrategy.graphicsInitialize();
        }
        catch (Exception e) {
            throw new RrdException("An error occured initializing the Rrd subsytem", e);
        }
    }

    private static void createStrategy() throws RrdException {
        if (m_rrdStrategy == null) {
            RrdStrategy rrdStategy = RrdUtils.constructStrategyInstance();
            if (USE_QUEUE) {
                rrdStategy = new QueuingRrdStrategy(rrdStategy);
            }
            m_rrdStrategy = rrdStategy;
        }
    }

    private static RrdStrategy constructStrategyInstance() throws RrdException {
        try {
            return (RrdStrategy)Class.forName(RRD_STRATEGY_CLASSNAME).newInstance();
        }
        catch (Exception e) {
            RrdUtils.log().error((Object)("Unable to load RrdStrategyClass " + RRD_STRATEGY_CLASSNAME), (Throwable)e);
            throw new RrdException("Unable to construct RrdStrategy: " + RRD_STRATEGY_CLASSNAME, e);
        }
    }

    public static boolean createRRD(String creator, String directory, String dsName, int step, String dsType, int dsHeartbeat, String dsMin, String dsMax, List rraList) throws RrdException {
        return RrdUtils.createRRD(creator, directory, dsName, step, Collections.singletonList(new RrdDataSource(dsName, dsType, dsHeartbeat, dsMin, dsMax)), rraList);
    }

    public static boolean createRRD(String creator, String directory, String rrdName, int step, List dataSources, List rraList) throws RrdException {
        String fileName = rrdName + RrdUtils.getExtension();
        String completePath = directory + File.separator + fileName;
        if (RrdUtils.log().isDebugEnabled()) {
            RrdUtils.log().debug((Object)("createRRD: rrd path and file name to create: " + completePath));
        }
        try {
            Object def = RrdUtils.getStrategy().createDefinition(creator, directory, rrdName, step, dataSources, rraList);
            RrdUtils.getStrategy().createFile(def);
            return true;
        }
        catch (Exception e) {
            RrdUtils.log().debug((Object)("An error occured creating rrdfile " + completePath), (Throwable)e);
            throw new RrdException("An error occured creating rrdfile " + completePath, e);
        }
    }

    private static Category log() {
        return ThreadCategory.getInstance(RrdUtils.class);
    }

    public static void updateRRD(String owner, String repositoryDir, String rrdName, String val) throws RrdException {
        RrdUtils.updateRRD(owner, repositoryDir, rrdName, System.currentTimeMillis(), val);
    }

    public static void updateRRD(String owner, String repositoryDir, String rrdName, long timestamp, String val) throws RrdException {
        String rrdFile = repositoryDir + File.separator + rrdName + RrdUtils.getExtension();
        long time = (timestamp + 500L) / 1000L;
        String updateVal = Long.toString(time) + ":" + val;
        RrdUtils.log().info((Object)("updateRRD:updating RRD file: " + rrdFile + " with value: " + updateVal));
        Object rrd = null;
        try {
            rrd = RrdUtils.getStrategy().openFile(rrdFile);
            RrdUtils.getStrategy().updateFile(rrd, owner, updateVal);
        }
        catch (Exception e) {
            RrdUtils.log().error((Object)("Error updating rrdFile " + rrdFile + " with value: " + updateVal), (Throwable)e);
            throw new RrdException("Error updating rrdFile " + rrdFile + " with value: " + updateVal, e);
        }
        finally {
            try {
                if (rrd != null) {
                    RrdUtils.getStrategy().closeFile(rrd);
                }
            }
            catch (Exception e) {
                throw new RrdException("Exception closing rrdDb", e);
            }
        }
        if (RrdUtils.log().isDebugEnabled()) {
            RrdUtils.log().debug((Object)"updateRRD: RRD update command completed.");
        }
    }

    public static Double fetchLastValue(String rrdFile, int interval) throws NumberFormatException, RrdException {
        return RrdUtils.getStrategy().fetchLastValue(rrdFile, interval);
    }

    public static Double fetchLastValueInRange(String rrdFile, int interval, int range) throws NumberFormatException, RrdException {
        return RrdUtils.getStrategy().fetchLastValueInRange(rrdFile, interval, range);
    }

    public static InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        return RrdUtils.getStrategy().createGraph(command, workDir);
    }

    public static String getExtension() {
        if (m_rrdExtension == null) {
            return RrdUtils.getStrategy().getDefaultFileExtension();
        }
        return m_rrdExtension;
    }
}

