/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Category;
import org.opennms.netmgt.rrd.RrdConfig;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;

public class QueuingRrdStrategy
implements RrdStrategy,
Runnable {
    RrdStrategy m_delegate;
    static final int UPDATE = 0;
    static final int CREATE = 1;
    static final int WRITE_THREADS = RrdConfig.getProperty("org.opennms.rrd.queuing.writethreads", 2);
    private static final boolean QUEUE_CREATES = RrdConfig.getProperty("org.opennms.rrd.queuing.queuecreates", false);
    private static final boolean PRIORITIZE_SIGS = RrdConfig.getProperty("org.opennms.rrd.queuing.prioritizeSignificatUpdates", true);
    private static final long INSIG_HIGH_WATER_MARK = RrdConfig.getProperty("org.opennms.rrd.queuing.inSigHighWaterMark", 0L);
    private static final long SIG_HIGH_WATER_MARK = RrdConfig.getProperty("org.opennms.rrd.queuing.sigHighWaterMark", 0L);
    private static final long QUEUE_HIGH_WATER_MARK = RrdConfig.getProperty("org.opennms.rrd.queuing.queueHighWaterMark", 0L);
    private static final long MODULUS = RrdConfig.getProperty("org.opennms.rrd.queuing.modulus", 10000L);
    private static final String LOG4J_CATEGORY = RrdConfig.getProperty("org.opennms.rrd.queuing.category", "UNCATEGORIZED");
    private static final long MAX_INSIG_UPDATE_SECONDS = RrdConfig.getProperty("org.opennms.rrd.queuing.maxInsigUpdateSeconds", 0L);
    private static final long WRITE_THREAD_SLEEP_TIME = RrdConfig.getProperty("org.opennms.rrd.queuing.writethread.sleepTime", 50L);
    private static final long WRITE_THREAD_EXIT_DELAY = RrdConfig.getProperty("org.opennms.rrd.queuing.writethread.exitDelay", 60000L);
    LinkedList filesWithSignificantWork = new LinkedList();
    LinkedList filesWithInsignificantWork = new LinkedList();
    Map pendingFileOperations = new HashMap();
    Map fileAssignments = new HashMap();
    Set reservedFiles = new HashSet();
    long totalOperationsPending = 0L;
    long enqueuedOperations = 0L;
    long dequeuedOperations = 0L;
    long significantOpsEnqueued = 0L;
    long significantOpsDequeued = 0L;
    long significantOpsCompleted = 0L;
    long dequeuedItems = 0L;
    long createsCompleted = 0L;
    long updatesCompleted = 0L;
    long errors = 0L;
    int threadsRunning = 0;
    long updateStart = 0L;
    long promotionCount = 0L;
    long lastLap = System.currentTimeMillis();
    long lastStatsTime = 0L;
    long lastEnqueued = 0L;
    long lastDequeued = 0L;
    long lastSignificantEnqueued = 0L;
    long lastSignificantDequeued = 0L;
    long lastSignificantCompleted = 0L;
    long lastDequeuedItems = 0L;
    long lastOpsPending = 0L;

    public Operation makeCreateOperation(String fileName, Object rrdDef) {
        return new CreateOperation(fileName, rrdDef);
    }

    public Operation makeUpdateOperation(String fileName, String owner, String update) {
        try {
            int colon = update.indexOf(58);
            if (colon >= 0 && Double.parseDouble(update.substring(colon + 1)) == 0.0) {
                long initialTimeStamp = Long.parseLong(update.substring(0, colon));
                if (initialTimeStamp == 0L) {
                    this.log("ZERO ERROR: created a zero update with ts=0 for file: " + fileName + " data: " + update);
                }
                return new ZeroUpdateOperation(fileName, initialTimeStamp);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return new UpdateOperation(fileName, update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOperation(Operation op) {
        QueuingRrdStrategy queuingRrdStrategy = this;
        synchronized (queuingRrdStrategy) {
            if (this.queueIsFull()) {
                this.log().error((Object)("RRD Data Queue is Full!! Discarding operation for file " + op.getFileName()));
                return;
            }
            if (op.isSignificant() && this.sigQueueIsFull()) {
                this.log().error((Object)("RRD Data Significant Queue is Full!! Discarding operation for file " + op.getFileName()));
                return;
            }
            if (!op.isSignificant() && this.inSigQueueIsFull()) {
                this.log().error((Object)("RRD Insignificant Data Queue is Full!! Discarding operation for file " + op.getFileName()));
                return;
            }
            this.storeAssignment(op);
            ++this.totalOperationsPending;
            ++this.enqueuedOperations;
            if (op.isSignificant()) {
                ++this.significantOpsEnqueued;
            }
            this.notifyAll();
            this.ensureThreadsStarted();
        }
    }

    private Category log() {
        return Category.getInstance((String)LOG4J_CATEGORY);
    }

    private boolean queueIsFull() {
        if (QUEUE_HIGH_WATER_MARK <= 0L) {
            return false;
        }
        return this.totalOperationsPending >= QUEUE_HIGH_WATER_MARK;
    }

    private boolean sigQueueIsFull() {
        if (SIG_HIGH_WATER_MARK <= 0L) {
            return false;
        }
        return this.totalOperationsPending >= SIG_HIGH_WATER_MARK;
    }

    private boolean inSigQueueIsFull() {
        if (INSIG_HIGH_WATER_MARK <= 0L) {
            return false;
        }
        return this.totalOperationsPending >= INSIG_HIGH_WATER_MARK;
    }

    public synchronized void ensureThreadsStarted() {
        if (this.threadsRunning < WRITE_THREADS) {
            ++this.threadsRunning;
            Thread t = new Thread(this);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getNext() {
        LinkedList ops = null;
        QueuingRrdStrategy queuingRrdStrategy = this;
        synchronized (queuingRrdStrategy) {
            String newAssignment;
            this.completeAssignment();
            while ((newAssignment = this.selectNewAssignment()) == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.updateStart == 0L) {
                this.updateStart = System.currentTimeMillis();
            }
            if ((ops = this.takeAssignment(newAssignment)) != null) {
                for (Operation op : ops) {
                    this.totalOperationsPending -= (long)op.getCount();
                    this.dequeuedOperations += (long)op.getCount();
                    if (!op.isSignificant()) continue;
                    this.significantOpsDequeued += (long)op.getCount();
                }
                ++this.dequeuedItems;
            }
        }
        return ops;
    }

    private synchronized void storeAssignment(Operation op) {
        LinkedList pendingOperations = (LinkedList)this.pendingFileOperations.get(op.getFileName());
        if (pendingOperations == null) {
            pendingOperations = new LinkedList();
            this.pendingFileOperations.put(op.getFileName(), pendingOperations);
            if (!PRIORITIZE_SIGS || op.isSignificant()) {
                this.filesWithSignificantWork.addLast(op.getFileName());
            } else {
                this.filesWithInsignificantWork.addLast(op.getFileName());
            }
        } else if (PRIORITIZE_SIGS && op.isSignificant() && this.hasOnlyInsignificant(pendingOperations)) {
            this.filesWithSignificantWork.addLast(op.getFileName());
        }
        this.promoteAgedFiles();
        op.addToPendingList(pendingOperations);
    }

    private synchronized void promoteAgedFiles() {
        double millisPerPromotion;
        long nextPromotionMillis;
        if (!PRIORITIZE_SIGS) {
            return;
        }
        if (MAX_INSIG_UPDATE_SECONDS == 0L || this.filesWithInsignificantWork.isEmpty()) {
            return;
        }
        long now = System.currentTimeMillis();
        long elapsedMillis = Math.max(now - this.updateStart, 1L);
        if (elapsedMillis > (nextPromotionMillis = (long)((millisPerPromotion = (double)MAX_INSIG_UPDATE_SECONDS * 1000.0 / (double)this.filesWithInsignificantWork.size()) * (double)this.promotionCount))) {
            String file = (String)this.filesWithInsignificantWork.removeFirst();
            this.filesWithSignificantWork.addFirst(file);
            ++this.promotionCount;
        }
    }

    private boolean hasOnlyInsignificant(LinkedList pendingOps) {
        for (Operation op : pendingOps) {
            if (!op.isSignificant()) continue;
            return false;
        }
        return true;
    }

    private LinkedList takeAssignment(String newAssignment) {
        this.fileAssignments.put(Thread.currentThread(), newAssignment);
        this.reservedFiles.add(newAssignment);
        LinkedList ops = (LinkedList)this.pendingFileOperations.remove(newAssignment);
        return ops;
    }

    private String selectNewAssignment() {
        String fn;
        Iterator it = this.filesWithSignificantWork.iterator();
        while (it.hasNext()) {
            fn = (String)it.next();
            if (this.reservedFiles.contains(fn)) continue;
            it.remove();
            return fn;
        }
        it = this.filesWithInsignificantWork.iterator();
        while (it.hasNext()) {
            fn = (String)it.next();
            if (this.reservedFiles.contains(fn)) continue;
            it.remove();
            return fn;
        }
        return null;
    }

    private synchronized void completeAssignment() {
        String previousAssignment = (String)this.fileAssignments.remove(Thread.currentThread());
        if (previousAssignment != null) {
            this.reservedFiles.remove(previousAssignment);
        }
    }

    public QueuingRrdStrategy(RrdStrategy delegate) {
        this.m_delegate = delegate;
    }

    public RrdStrategy getDelegate() {
        return this.m_delegate;
    }

    public void closeFile(Object rrd) throws Exception {
    }

    public Object createDefinition(String creator, String directory, String dsName, int step, String dsType, int dsHeartbeat, String dsMin, String dsMax, List rraList) throws Exception {
        return this.createDefinition(creator, directory, dsName, step, Collections.singletonList(new RrdDataSource(dsName, dsType, dsHeartbeat, dsMin, dsMax)), rraList);
    }

    public Object createDefinition(String creator, String directory, String rrdName, int step, List dataSources, List rraList) throws Exception {
        String fileName = directory + File.separator + rrdName + RrdUtils.getExtension();
        Object def = this.m_delegate.createDefinition(creator, directory, rrdName, step, dataSources, rraList);
        return this.makeCreateOperation(fileName, def);
    }

    public void createFile(Object op) throws Exception {
        if (QUEUE_CREATES) {
            this.addOperation((Operation)op);
        } else {
            this.m_delegate.createFile(((Operation)op).getData());
        }
    }

    public void initialize() throws Exception {
        this.m_delegate.initialize();
    }

    public void graphicsInitialize() throws Exception {
        this.m_delegate.graphicsInitialize();
    }

    public Object openFile(String fileName) throws Exception {
        return fileName;
    }

    public void updateFile(Object rrdFile, String owner, String data) throws Exception {
        this.addOperation(this.makeUpdateOperation((String)rrdFile, owner, data));
    }

    public Double fetchLastValue(String rrdFile, int interval) throws NumberFormatException, RrdException {
        return this.m_delegate.fetchLastValue(rrdFile, interval);
    }

    public Double fetchLastValueInRange(String rrdFile, int interval, int range) throws NumberFormatException, RrdException {
        return this.m_delegate.fetchLastValueInRange(rrdFile, interval, range);
    }

    public InputStream createGraph(String command, File workDir) throws IOException, RrdException {
        return this.m_delegate.createGraph(command, workDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            long waitStart = -1L;
            long delayed = 0L;
            while (delayed < WRITE_THREAD_EXIT_DELAY) {
                if (this.totalOperationsPending > 0L) {
                    delayed = 0L;
                    waitStart = -1L;
                    this.processPendingOperations();
                    continue;
                }
                if (waitStart < 0L) {
                    waitStart = System.currentTimeMillis();
                }
                try {
                    Thread.sleep(WRITE_THREAD_SLEEP_TIME);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long now = System.currentTimeMillis();
                delayed = now - waitStart;
            }
        }
        finally {
            QueuingRrdStrategy queuingRrdStrategy = this;
            synchronized (queuingRrdStrategy) {
                --this.threadsRunning;
                this.completeAssignment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingOperations() {
        LinkedList ops;
        String fileName;
        Object rrd;
        block7: {
            rrd = null;
            fileName = null;
            ops = this.getNext();
            if (ops != null) break block7;
            this.processClose(rrd);
            return;
        }
        try {
            for (Operation op : ops) {
                if (!op.isSignificant()) continue;
                ++this.significantOpsCompleted;
            }
            for (Operation op : ops) {
                fileName = op.getFileName();
                rrd = op.process(rrd);
            }
            this.processClose(rrd);
        }
        catch (Exception e) {
            try {
                ++this.errors;
                this.logLapTime("Error updating file " + fileName + ": " + e.getMessage());
                this.log("Error upading file " + fileName + ": " + e.getMessage(), e);
                this.processClose(rrd);
            }
            catch (Throwable throwable) {
                this.processClose(rrd);
                throw throwable;
            }
        }
    }

    private void processClose(Object rrd) {
        if (rrd != null) {
            try {
                this.m_delegate.closeFile(rrd);
            }
            catch (Throwable t) {
                this.logLapTime("Throwable received while closing file", t);
            }
        }
    }

    public String getStats() {
        long now = System.currentTimeMillis();
        long currentElapsedMillis = Math.max(now - this.lastStatsTime, 1L);
        long totalElapsedMillis = Math.max(now - this.updateStart, 1L);
        long currentEnqueuedOps = this.enqueuedOperations - this.lastEnqueued;
        long currentDequeuedOps = this.dequeuedOperations - this.lastDequeued;
        long currentDequeuedItems = this.dequeuedItems - this.lastDequeuedItems;
        long currentSigOpsEnqueued = this.significantOpsEnqueued - this.lastSignificantEnqueued;
        long currentSigOpsDequeued = this.significantOpsDequeued - this.lastSignificantDequeued;
        long currentEnqueueRate = (long)((double)currentEnqueuedOps * 1000.0 / (double)currentElapsedMillis);
        long currentSigEnqueueRate = (long)((double)currentSigOpsEnqueued * 1000.0 / (double)currentElapsedMillis);
        long currentInsigEnqueueRate = (long)((double)(currentEnqueuedOps - currentSigOpsEnqueued) * 1000.0 / (double)currentElapsedMillis);
        long overallEnqueueRate = (long)((double)this.enqueuedOperations * 1000.0 / (double)totalElapsedMillis);
        long overallSigEnqueueRate = (long)((double)this.significantOpsEnqueued * 1000.0 / (double)totalElapsedMillis);
        long overallInsigEnqueueRate = (long)((double)(this.enqueuedOperations - this.significantOpsEnqueued) * 1000.0 / (double)totalElapsedMillis);
        long currentDequeueRate = (long)((double)currentDequeuedOps * 1000.0 / (double)currentElapsedMillis);
        long currentSigDequeueRate = (long)((double)currentSigOpsDequeued * 1000.0 / (double)currentElapsedMillis);
        long currentInsigDequeueRate = (long)((double)(currentDequeuedOps - currentSigOpsDequeued) * 1000.0 / (double)currentElapsedMillis);
        long overallDequeueRate = (long)((double)this.dequeuedOperations * 1000.0 / (double)totalElapsedMillis);
        long overallSigDequeueRate = (long)((double)this.significantOpsDequeued * 1000.0 / (double)totalElapsedMillis);
        long overallInsigDequeueRate = (long)((double)(this.dequeuedOperations - this.significantOpsDequeued) * 1000.0 / (double)totalElapsedMillis);
        long currentItemDequeueRate = (long)((double)currentDequeuedItems * 1000.0 / (double)currentElapsedMillis);
        long overallItemDequeueRate = (long)((double)this.dequeuedItems * 1000.0 / (double)totalElapsedMillis);
        String stats = "\nQS:\ttotalOperationsPending=" + this.totalOperationsPending + ", significantOpsPending=" + (this.significantOpsEnqueued - this.significantOpsCompleted) + ", filesWithSignificantWork=" + this.filesWithSignificantWork.size() + ", filesWithInsignificantWork=" + this.filesWithInsignificantWork.size() + "\nQS:\t" + ", createsCompleted=" + this.createsCompleted + ", udpatesCompleted=" + this.updatesCompleted + ", errors=" + this.errors + ", promotionRate=" + (double)this.promotionCount * 1000.0 / (double)totalElapsedMillis + ", promotionCount=" + this.promotionCount + "\nQS:\t" + ", currentEnqueueRates=(" + currentSigEnqueueRate + "/" + currentInsigEnqueueRate + "/" + currentEnqueueRate + ")" + ", currentDequeueRate=(" + currentSigDequeueRate + "/" + currentInsigDequeueRate + "/" + currentDequeueRate + ")" + ", currentItemDequeRate=" + currentItemDequeueRate + ", currentOpsPerUpdate=" + (double)currentDequeuedOps / Math.max((double)currentDequeuedItems, 1.0) + ", currentPrcntSignificant=" + (double)currentSigOpsEnqueued * 100.0 / Math.max((double)currentEnqueuedOps, 1.0) + "%" + ", elapsedTime=" + (currentElapsedMillis + 500L) / 1000L + "\nQS:\t" + ", overallEnqueueRate=(" + overallSigEnqueueRate + "/" + overallInsigEnqueueRate + "/" + overallEnqueueRate + ")" + ", overallDequeueRate=(" + overallSigDequeueRate + "/" + overallInsigDequeueRate + "/" + overallDequeueRate + ")" + ", overallItemDequeRate=" + overallItemDequeueRate + ", overallOpsPerUpdate=" + (double)this.dequeuedOperations / Math.max((double)this.dequeuedItems, 1.0) + ", overallPrcntSignificant=" + (double)this.significantOpsEnqueued * 100.0 / Math.max((double)this.enqueuedOperations, 1.0) + "%" + ", totalElapsedTime=" + (totalElapsedMillis + 500L) / 1000L;
        this.lastStatsTime = now;
        this.lastEnqueued = this.enqueuedOperations;
        this.lastDequeued = this.dequeuedOperations;
        this.lastDequeuedItems = this.dequeuedItems;
        this.lastSignificantEnqueued = this.significantOpsEnqueued;
        this.lastSignificantDequeued = this.significantOpsDequeued;
        this.lastSignificantCompleted = this.significantOpsCompleted;
        this.lastOpsPending = this.totalOperationsPending;
        return stats;
    }

    public void logStats() {
        this.logLapTime(this.getStats());
    }

    void logLapTime(String message) {
        this.log(message + " " + this.getLapTime());
    }

    void logLapTime(String message, Throwable t) {
        this.log(message + " " + this.getLapTime(), t);
    }

    private void log(String msg) {
        Category log = Category.getInstance((String)LOG4J_CATEGORY);
        log.debug((Object)msg);
    }

    private void log(String msg, Throwable t) {
        Category log = Category.getInstance((String)LOG4J_CATEGORY);
        log.debug((Object)msg, t);
    }

    public String getLapTime() {
        long newLap = System.currentTimeMillis();
        double seconds = (double)(newLap - this.lastLap) / 1000.0;
        this.lastLap = newLap;
        return "[" + seconds + " sec]";
    }

    public int getGraphRightOffset() {
        return this.m_delegate.getGraphRightOffset();
    }

    public int getGraphTopOffsetWithText() {
        return this.m_delegate.getGraphTopOffsetWithText();
    }

    public String getDefaultFileExtension() {
        return this.m_delegate.getDefaultFileExtension();
    }

    public class ZeroUpdateOperation
    extends UpdateOperation {
        long timeStamp;
        long interval;
        int count;

        ZeroUpdateOperation(String fileName, long intitialTimeStamp) {
            super(fileName, "0", false);
            this.interval = 0L;
            this.timeStamp = intitialTimeStamp;
            this.count = 1;
        }

        Object process(Object rrd) throws Exception {
            long ts = this.getFirstTimeStamp();
            for (int i = 0; i < this.count; ++i) {
                if (rrd == null) {
                    rrd = QueuingRrdStrategy.this.m_delegate.openFile(this.getFileName());
                }
                String update = ts + ":0";
                try {
                    QueuingRrdStrategy.this.m_delegate.updateFile(rrd, "", update);
                }
                catch (Exception e) {
                    throw new Exception("Error processing update " + i + " for file " + this.getFileName() + ": " + update, e);
                }
                ts += this.getInterval();
                if (++QueuingRrdStrategy.this.updatesCompleted % MODULUS != 0L) continue;
                QueuingRrdStrategy.this.logStats();
            }
            return rrd;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int newCount) {
            this.count = newCount;
        }

        public long getFirstTimeStamp() {
            return this.timeStamp;
        }

        public long getLastTimeStamp() {
            return this.timeStamp + this.interval * (long)(this.count - 1);
        }

        public long getInterval() {
            return this.interval;
        }

        public void setInterval(long newInterval) {
            this.interval = newInterval;
        }

        public void mergeUpdates(ZeroUpdateOperation op) throws IllegalArgumentException {
            long opSpacing = op.getFirstTimeStamp() - this.getLastTimeStamp();
            long tolerance = this.getInterval() / 5L;
            if (opSpacing == 0L) {
                throw new IllegalArgumentException("unable to merge op because the spacing " + opSpacing + " is 0");
            }
            if (this.getInterval() > 0L && Math.abs(opSpacing - this.getInterval()) >= tolerance) {
                throw new IllegalArgumentException("unable to merge op because the spacing " + opSpacing + " is different than the current interval " + this.getInterval());
            }
            if (this.getInterval() > 0L && op.getInterval() > 0L && Math.abs(op.getInterval() - this.getInterval()) >= tolerance) {
                throw new IllegalArgumentException("unable to merge op because the new op interval " + op.getInterval() + " is different than the current interval " + this.getInterval());
            }
            int newCount = this.getCount() + op.getCount();
            long newInterval = ((long)(this.getCount() - 1) * this.getInterval() + (long)(op.getCount() - 1) + op.getInterval() + opSpacing) / (long)(newCount - 1);
            this.setCount(newCount);
            this.setInterval(newInterval);
        }

        void addToPendingList(LinkedList pendingOperations) {
            if (pendingOperations.size() > 0 && pendingOperations.getLast() instanceof ZeroUpdateOperation) {
                ZeroUpdateOperation zeroOp = (ZeroUpdateOperation)pendingOperations.getLast();
                try {
                    zeroOp.mergeUpdates(this);
                }
                catch (IllegalArgumentException e) {
                    QueuingRrdStrategy.this.log(e.getMessage());
                    super.addToPendingList(pendingOperations);
                }
            } else {
                super.addToPendingList(pendingOperations);
            }
        }
    }

    public class UpdateOperation
    extends Operation {
        UpdateOperation(String fileName, String data) {
            super(fileName, 0, data, true);
        }

        UpdateOperation(String fileName, String data, boolean significant) {
            super(fileName, 0, data, significant);
        }

        Object process(Object rrd) throws Exception {
            if (rrd == null) {
                rrd = QueuingRrdStrategy.this.m_delegate.openFile(this.getFileName());
            }
            String update = (String)this.getData();
            try {
                QueuingRrdStrategy.this.m_delegate.updateFile(rrd, "", update);
            }
            catch (Exception e) {
                throw new Exception("Error processing update for file " + this.getFileName() + ": " + update, e);
            }
            if (++QueuingRrdStrategy.this.updatesCompleted % MODULUS == 0L) {
                QueuingRrdStrategy.this.logStats();
            }
            return rrd;
        }
    }

    public class CreateOperation
    extends Operation {
        CreateOperation(String fileName, Object rrdDef) {
            super(fileName, 1, rrdDef, true);
        }

        Object process(Object rrd) throws Exception {
            if (rrd != null) {
                QueuingRrdStrategy.this.log("WHAT! rrd open but not created?");
                QueuingRrdStrategy.this.m_delegate.closeFile(rrd);
                rrd = null;
            }
            QueuingRrdStrategy.this.m_delegate.createFile(this.getData());
            ++QueuingRrdStrategy.this.createsCompleted;
            return rrd;
        }
    }

    static abstract class Operation {
        String fileName;
        int type;
        Object data;
        boolean significant;

        Operation(String fileName, int type, Object data, boolean significant) {
            this.fileName = fileName;
            this.type = type;
            this.data = data;
            this.significant = significant;
        }

        int getCount() {
            return 1;
        }

        String getFileName() {
            return this.fileName;
        }

        int getType() {
            return this.type;
        }

        Object getData() {
            return this.data;
        }

        boolean isSignificant() {
            return this.significant;
        }

        void addToPendingList(LinkedList pendingOperations) {
            pendingOperations.add(this);
        }

        abstract Object process(Object var1) throws Exception;
    }
}

