/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.io.IOException;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JAgentConfig;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpHelpers {
    public static PDU createPDU() {
        return SnmpHelpers.createPDU(0);
    }

    public static PDU createPDU(int version) {
        Object request = version == 3 ? new ScopedPDU() : new PDU();
        return request;
    }

    public static Snmp createSnmpSession() throws IOException {
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        Snmp snmp = new Snmp((TransportMapping)transport);
        return snmp;
    }

    public static Snmp createSnmpSession(Snmp4JAgentConfig agentConfig) throws IOException {
        Snmp session = SnmpHelpers.createSnmpSession();
        if (agentConfig.isSnmpV3()) {
            session.getUSM().addUser(agentConfig.getSecurityName(), agentConfig.getUser());
        }
        return session;
    }

    public static String versionString(int version) {
        String retVal = null;
        if (version == 0) {
            retVal = "SNMPv1";
        }
        if (version == 1) {
            retVal = "SNMPv2c";
        }
        if (version == 3) {
            retVal = "SNMPv3";
        }
        return retVal;
    }
}

