/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpStrategy;
import org.opennms.netmgt.snmp.SnmpTrapBuilder;
import org.opennms.netmgt.snmp.SnmpV1TrapBuilder;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.SnmpValueFactory;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.opennms.netmgt.snmp.TrapNotificationListener;
import org.opennms.netmgt.snmp.TrapProcessorFactory;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JAgentConfig;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JTrapNotifier;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JV1TrapBuilder;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JV2TrapBuilder;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValue;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JValueFactory;
import org.opennms.netmgt.snmp.snmp4j.Snmp4JWalker;
import org.opennms.netmgt.snmp.snmp4j.SnmpHelpers;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.CommunityTarget;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class Snmp4JStrategy
implements SnmpStrategy {
    public static Map m_registrations = new HashMap();
    private Snmp4JValueFactory m_valueFactory;
    private static boolean m_initialized = false;
    private static Snmp sm_session;

    private static void initialize() {
        if (!m_initialized) {
            MPv3.setEnterpriseID((int)5813);
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            SecurityModels.getInstance().addSecurityModel((SecurityModel)usm);
            m_initialized = true;
        }
    }

    public Snmp4JStrategy() {
        Snmp4JStrategy.initialize();
    }

    public SnmpWalker createWalker(SnmpAgentConfig snmpAgentConfig, String name, CollectionTracker tracker) {
        return new Snmp4JWalker(new Snmp4JAgentConfig(snmpAgentConfig), name, tracker);
    }

    public SnmpValue[] getBulk(SnmpAgentConfig agentConfig, SnmpObjId[] oid) {
        return null;
    }

    public SnmpValue set(SnmpAgentConfig agentConfig, SnmpObjId oid, SnmpValue value) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("set: OID: " + oid + " value: " + value.toString() + " for Agent:" + agentConfig));
        }
        SnmpObjId[] oids = new SnmpObjId[]{oid};
        SnmpValue[] values = new SnmpValue[]{value};
        return this.set(agentConfig, oids, values)[0];
    }

    public SnmpValue[] set(SnmpAgentConfig snmpAgentConfig, SnmpObjId[] oids, SnmpValue[] values) {
        Snmp4JAgentConfig agentConfig = new Snmp4JAgentConfig(snmpAgentConfig);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("get: OID: " + oids + " values: " + values + " for Agent:" + agentConfig));
        }
        return this.send(agentConfig, -93, oids, values);
    }

    public SnmpValue get(SnmpAgentConfig agentConfig, SnmpObjId oid) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("get: OID: " + oid + " for Agent:" + agentConfig));
        }
        SnmpObjId[] oids = new SnmpObjId[]{oid};
        SnmpValue[] values = this.get(agentConfig, oids);
        return values[0];
    }

    public SnmpValue[] get(SnmpAgentConfig snmpAgentConfig, SnmpObjId[] oids) {
        Snmp4JAgentConfig agentConfig = new Snmp4JAgentConfig(snmpAgentConfig);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("get: OID: " + oids + " for Agent:" + agentConfig));
        }
        return this.send(agentConfig, -96, oids);
    }

    public SnmpValue getNext(SnmpAgentConfig agentConfig, SnmpObjId oid) {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("getNext: OID: " + oid + " for Agent:" + agentConfig));
        }
        SnmpObjId[] oids = new SnmpObjId[]{oid};
        SnmpValue[] values = this.getNext(agentConfig, oids);
        return values[0];
    }

    public SnmpValue[] getNext(SnmpAgentConfig snmpAgentConfig, SnmpObjId[] oids) {
        Snmp4JAgentConfig agentConfig = new Snmp4JAgentConfig(snmpAgentConfig);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("get: OID: " + oids + " for Agent:" + agentConfig));
        }
        return this.send(agentConfig, -95, oids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SnmpValue[] send(Snmp4JAgentConfig agentConfig, int pduType, SnmpObjId[] oids) {
        SnmpValue[] values = new SnmpValue[]{null};
        Snmp session = null;
        try {
            session = SnmpHelpers.createSnmpSession(agentConfig);
            session = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            session.listen();
            session.getUSM().addUser(agentConfig.getSecurityName(), new UsmUser(agentConfig.getSecurityName(), agentConfig.getAuthProtocol(), agentConfig.getAuthPassPhrase(), agentConfig.getPrivProtocol(), agentConfig.getPrivPassPhrase()));
            Target target = agentConfig.getTarget();
            PDU pdu = SnmpHelpers.createPDU(agentConfig.getVersion());
            pdu.setType(pduType);
            if (!this.buildPdu(pdu, oids)) {
                SnmpValue[] snmpValueArray = null;
                return snmpValueArray;
            }
            ResponseEvent responseEvent = session.send(pdu, target);
            if (responseEvent.getResponse() == null) {
                this.log().warn((Object)("send: Timeout.  Agent: " + agentConfig));
            } else if (responseEvent.getResponse().get(0).getSyntax() == 5) {
                values[0] = null;
            } else if (responseEvent.getError() != null) {
                this.log().warn((Object)("send: Error during get operation.  Error: " + responseEvent.getError().getLocalizedMessage()));
            } else if (responseEvent.getResponse().getType() == -88) {
                this.log().warn((Object)("send: Error during get operation.  Report returned with varbinds: " + responseEvent.getResponse().getVariableBindings()));
            } else if (responseEvent.getResponse().getVariableBindings().size() < 1) {
                this.log().warn((Object)"send: Received PDU with 0 varbinds.");
            } else {
                values = new Snmp4JValue[responseEvent.getResponse().getVariableBindings().size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = new Snmp4JValue(responseEvent.getResponse().get(0).getVariable());
                }
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("send: Snmp operation successful. Value: " + values));
                }
            }
        }
        catch (IOException e) {
            this.log().error((Object)("getNext: Could not create Snmp session for Agent: " + agentConfig + ". " + e));
        }
        finally {
            try {
                session.close();
            }
            catch (IOException e) {
                this.log().error((Object)("send: Error closinging SNMP connection: " + e));
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SnmpValue[] send(Snmp4JAgentConfig agentConfig, int pduType, SnmpObjId[] oids, SnmpValue[] values) {
        SnmpValue[] retvalues = new SnmpValue[]{null};
        Snmp session = null;
        try {
            session = SnmpHelpers.createSnmpSession(agentConfig);
            session = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
            session.listen();
            session.getUSM().addUser(agentConfig.getSecurityName(), new UsmUser(agentConfig.getSecurityName(), agentConfig.getAuthProtocol(), agentConfig.getAuthPassPhrase(), agentConfig.getPrivProtocol(), agentConfig.getPrivPassPhrase()));
            Target target = agentConfig.getTarget();
            PDU pdu = SnmpHelpers.createPDU(agentConfig.getVersion());
            pdu.setType(pduType);
            if (!this.buildPdu(pdu, oids, values)) {
                SnmpValue[] snmpValueArray = null;
                return snmpValueArray;
            }
            ResponseEvent responseEvent = session.send(pdu, target);
            if (responseEvent.getResponse() == null) {
                this.log().warn((Object)("send: Timeout.  Agent: " + agentConfig));
            } else if (responseEvent.getResponse().get(0).getSyntax() == 5) {
                values[0] = null;
            } else if (responseEvent.getError() != null) {
                this.log().warn((Object)("send: Error during get operation.  Error: " + responseEvent.getError().getLocalizedMessage()));
            } else if (responseEvent.getResponse().getType() == -88) {
                this.log().warn((Object)("send: Error during get operation.  Report returned with varbinds: " + responseEvent.getResponse().getVariableBindings()));
            } else if (responseEvent.getResponse().getVariableBindings().size() < 1) {
                this.log().warn((Object)"send: Received PDU with 0 varbinds.");
            } else {
                retvalues = new Snmp4JValue[responseEvent.getResponse().getVariableBindings().size()];
                for (int i = 0; i < values.length; ++i) {
                    retvalues[i] = new Snmp4JValue(responseEvent.getResponse().get(0).getVariable());
                }
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("send: Snmp operation successful. Value: " + values));
                }
            }
        }
        catch (IOException e) {
            this.log().error((Object)("getNext: Could not create Snmp session for Agent: " + agentConfig + ". " + e));
        }
        finally {
            try {
                session.close();
            }
            catch (IOException e) {
                this.log().error((Object)("send: Error closinging SNMP connection: " + e));
            }
        }
        return retvalues;
    }

    private boolean buildPdu(PDU pdu, SnmpObjId[] oids) {
        for (int i = 0; i < oids.length; ++i) {
            VariableBinding vb = new VariableBinding(new OID(oids[i].toString()));
            pdu.add(vb);
        }
        return pdu.getVariableBindings().size() == oids.length;
    }

    private boolean buildPdu(PDU pdu, SnmpObjId[] oids, SnmpValue[] values) {
        VariableBinding vb = null;
        if (values == null) {
            return this.buildPdu(pdu, oids);
        }
        if (oids.length != values.length) {
            return false;
        }
        for (int i = 0; i < oids.length; ++i) {
            vb = new VariableBinding(new OID(oids[i].toString()), new Snmp4JValue(values[0].getType(), values[0].getBytes()).getVariable());
            pdu.add(vb);
        }
        return pdu.getVariableBindings().size() == oids.length;
    }

    private Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public SnmpValueFactory getValueFactory() {
        if (this.m_valueFactory == null) {
            this.m_valueFactory = new Snmp4JValueFactory();
        }
        return this.m_valueFactory;
    }

    public void registerForTraps(TrapNotificationListener listener, TrapProcessorFactory processorFactory, int snmpTrapPort) throws IOException {
        RegistrationInfo info = new RegistrationInfo(listener, snmpTrapPort);
        Snmp4JTrapNotifier m_trapHandler = new Snmp4JTrapNotifier(listener, processorFactory);
        info.setHandler(m_trapHandler);
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping(new UdpAddress(snmpTrapPort));
        info.setTransportMapping((TransportMapping)transport);
        Snmp snmp = new Snmp((TransportMapping)transport);
        snmp.addCommandResponder((CommandResponder)m_trapHandler);
        info.setSession(snmp);
        m_registrations.put(listener, info);
        snmp.listen();
    }

    public void unregisterForTraps(TrapNotificationListener listener, int snmpTrapPort) throws IOException {
        RegistrationInfo info = (RegistrationInfo)m_registrations.remove(listener);
        info.getSession().close();
    }

    public SnmpV1TrapBuilder getV1TrapBuilder() {
        return new Snmp4JV1TrapBuilder();
    }

    public SnmpTrapBuilder getV2TrapBuilder() {
        return new Snmp4JV2TrapBuilder();
    }

    public static void send(String agentAddress, int port, String community, PDU pdu) throws Exception {
        Snmp snmp = Snmp4JStrategy.getSession();
        Address targetAddress = GenericAddress.parse((String)("udp:" + agentAddress + "/" + port));
        CommunityTarget target = new CommunityTarget(targetAddress, new OctetString(community.getBytes()));
        target.setVersion(pdu instanceof PDUv1 ? 0 : 1);
        snmp.send(pdu, (Target)target);
    }

    private static Snmp getSession() throws IOException {
        if (sm_session == null) {
            sm_session = new Snmp((TransportMapping)new DefaultUdpTransportMapping());
        }
        return sm_session;
    }

    public static void sendTest(String agentAddress, int port, String community, PDU pdu) {
        for (RegistrationInfo info : m_registrations.values()) {
            if (port != info.getPort()) continue;
            Snmp snmp = info.getSession();
            MessageDispatcher dispatcher = snmp.getMessageDispatcher();
            TransportMapping transport = info.getTransportMapping();
            int securityModel = pdu instanceof PDUv1 ? 1 : 2;
            int messageModel = pdu instanceof PDUv1 ? 0 : 1;
            CommandResponderEvent e = new CommandResponderEvent(dispatcher, transport, (Address)new IpAddress(agentAddress), messageModel, securityModel, community.getBytes(), 1, new PduHandle(), pdu, 1000, null);
            info.getHandler().processPdu(e);
        }
    }

    public static class RegistrationInfo {
        public TrapNotificationListener m_listener;
        int m_trapPort;
        Snmp m_trapSession;
        Snmp4JTrapNotifier m_trapHandler;
        private TransportMapping m_transportMapping;

        RegistrationInfo(TrapNotificationListener listener, int trapPort) {
            if (listener == null) {
                throw new NullPointerException("listener is null");
            }
            this.m_listener = listener;
            this.m_trapPort = trapPort;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RegistrationInfo) {
                RegistrationInfo info = (RegistrationInfo)obj;
                return this.m_listener == info.m_listener && this.m_trapPort == info.m_trapPort;
            }
            return false;
        }

        public int hashCode() {
            return this.m_listener.hashCode() ^ this.m_trapPort;
        }

        public void setSession(Snmp trapSession) {
            this.m_trapSession = trapSession;
        }

        public Snmp getSession() {
            return this.m_trapSession;
        }

        public void setHandler(Snmp4JTrapNotifier trapHandler) {
            this.m_trapHandler = trapHandler;
        }

        public Snmp4JTrapNotifier getHandler() {
            return this.m_trapHandler;
        }

        public int getPort() {
            return this.m_trapPort;
        }

        public void setTransportMapping(TransportMapping transport) {
            this.m_transportMapping = transport;
        }

        public TransportMapping getTransportMapping() {
            return this.m_transportMapping;
        }
    }
}

