/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp.snmp4j;

import java.net.InetAddress;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.snmp4j.CommunityTarget;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;

public class Snmp4JAgentConfig {
    private SnmpAgentConfig m_config;

    public Snmp4JAgentConfig(SnmpAgentConfig config) {
        this.m_config = config;
    }

    public InetAddress getInetAddress() {
        return this.m_config.getAddress();
    }

    public OctetString getAuthPassPhrase() {
        return this.createOctetString(this.m_config.getAuthPassPhrase());
    }

    public OID getAuthProtocol() {
        return this.convertAuthProtocol(this.m_config.getAuthProtocol());
    }

    public int getMaxRequestSize() {
        return this.m_config.getMaxRequestSize();
    }

    public int getMaxVarsPerPdu() {
        return this.m_config.getMaxVarsPerPdu();
    }

    public int getPort() {
        return this.m_config.getPort();
    }

    public int getRetries() {
        return this.m_config.getRetries();
    }

    public int getSecurityLevel() {
        return this.convertSecurityLevel(this.m_config.getSecurityLevel());
    }

    public OctetString getSecurityName() {
        return this.convertSecurityName(this.m_config.getSecurityName());
    }

    public int getTimeout() {
        return this.m_config.getTimeout();
    }

    public int getVersion() {
        return this.convertVersion(this.m_config.getVersion());
    }

    public String getWriteCommunity() {
        return this.m_config.getWriteCommunity();
    }

    public String toString() {
        return this.m_config.toString();
    }

    private Address convertAddress(InetAddress address, int port) {
        String transportAddress = address.getHostAddress();
        transportAddress = transportAddress + "/" + port;
        UdpAddress targetAddress = new UdpAddress(transportAddress);
        return targetAddress;
    }

    private int convertVersion(int version) {
        switch (version) {
            case 3: {
                return 3;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    private OctetString createOctetString(String s) {
        if (s == null) {
            return null;
        }
        OctetString octetString = s.startsWith("0x") ? OctetString.fromHexString((String)s.substring(2), (char)':') : new OctetString(s);
        return octetString;
    }

    private OctetString convertSecurityName(String securityName) {
        return new OctetString(securityName);
    }

    private OID convertPrivProtocol(String privProtocol) {
        if (privProtocol == null) {
            return null;
        }
        if (privProtocol.equals("DES")) {
            return PrivDES.ID;
        }
        if (privProtocol.equals("AES128") || privProtocol.equals("AES")) {
            return PrivAES128.ID;
        }
        if (privProtocol.equals("AES192")) {
            return PrivAES192.ID;
        }
        if (privProtocol.equals("AES256")) {
            return PrivAES256.ID;
        }
        throw new IllegalArgumentException("Privacy protocol " + privProtocol + " not supported");
    }

    private OctetString convertCommunity(String community) {
        return new OctetString(community);
    }

    private OID convertAuthProtocol(String authProtocol) {
        if (authProtocol == null) {
            return null;
        }
        if (authProtocol.equals("MD5")) {
            return AuthMD5.ID;
        }
        if (authProtocol.equals("SHA")) {
            return AuthSHA.ID;
        }
        throw new IllegalArgumentException("Authentication protocol unsupported: " + authProtocol);
    }

    protected Target getTarget() {
        Target target = this.createTarget();
        target.setVersion(this.getVersion());
        target.setRetries(this.getRetries());
        target.setTimeout((long)this.getTimeout());
        target.setAddress(this.getAddress());
        target.setMaxSizeRequestPDU(this.getMaxRequestSize());
        return target;
    }

    private Target createTarget() {
        return this.isSnmpV3() ? this.createUserTarget() : this.createCommunityTarget();
    }

    boolean isSnmpV3() {
        return this.m_config.getVersion() == 3;
    }

    private Target createCommunityTarget() {
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(this.getReadCommunity());
        return target;
    }

    private Target createUserTarget() {
        UserTarget target = new UserTarget();
        target.setSecurityLevel(this.getSecurityLevel());
        target.setSecurityName(this.getSecurityName());
        return target;
    }

    private OctetString getReadCommunity() {
        return this.convertCommunity(this.m_config.getReadCommunity());
    }

    private Address getAddress() {
        return this.convertAddress(this.getInetAddress(), this.getPort());
    }

    public OID getPrivProtocol() {
        return this.convertPrivProtocol(this.m_config.getPrivProtocol());
    }

    public OctetString getPrivPassPhrase() {
        return this.createOctetString(this.m_config.getPrivPassPhrase());
    }

    private int convertSecurityLevel(int securityLevel) {
        switch (securityLevel) {
            case 2: {
                securityLevel = 2;
                break;
            }
            case 3: {
                securityLevel = 3;
                break;
            }
            case 1: {
                securityLevel = 1;
                break;
            }
            default: {
                securityLevel = 1;
            }
        }
        return securityLevel;
    }

    UsmUser getUser() {
        return new UsmUser(this.getSecurityName(), this.getAuthProtocol(), this.getAuthPassPhrase(), this.getPrivProtocol(), this.getPrivPassPhrase());
    }
}

