/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.snmp;

import java.net.InetAddress;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

public abstract class AbstractSnmpStore {
    private Map m_responseMap = new TreeMap();
    public static final String IFINDEX = "ifIndex";

    public abstract void storeResult(SnmpObjId var1, SnmpInstId var2, SnmpValue var3);

    public Integer getInt32(String key) {
        SnmpValue val = this.getValue(key);
        return val == null ? null : new Integer(val.toInt());
    }

    public Long getUInt32(String key) {
        SnmpValue val = this.getValue(key);
        return val == null ? null : new Long(val.toLong());
    }

    public String getDisplayString(String key) {
        SnmpValue val = this.getValue(key);
        return val == null ? null : val.toDisplayString();
    }

    public String getHexString(String key) {
        SnmpValue val = this.getValue(key);
        return val == null ? null : val.toHexString();
    }

    public InetAddress getIPAddress(String key) {
        SnmpValue val = this.getValue(key);
        return val == null ? null : val.toInetAddress();
    }

    public String getObjectID(String key) {
        return this.getValue(key) == null ? null : this.getValue(key).toString();
    }

    public SnmpValue getValue(String key) {
        return (SnmpValue)this.m_responseMap.get(key);
    }

    protected void putValue(String key, SnmpValue value) {
        this.m_responseMap.put(key, value);
    }

    public Integer getIfIndex() {
        return this.getInt32(IFINDEX);
    }

    protected void putIfIndex(int ifIndex) {
        this.putValue(IFINDEX, SnmpUtils.getValueFactory().getInt32(ifIndex));
    }

    public int size() {
        return this.m_responseMap.size();
    }

    public boolean isEmpty() {
        return this.m_responseMap.isEmpty();
    }
}

