/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

public class ContextHandlerCollection
extends HandlerCollection {
    private PathMap _contextMap;
    private Class _contextClass = ContextHandler.class;

    public void mapContexts() {
        this._contextMap = null;
        Handler[] handlers = this.getHandlers();
        if (handlers != null && handlers.length > 0) {
            PathMap contextMap = new PathMap();
            ArrayList list = new ArrayList();
            for (int i = 0; i < handlers.length; ++i) {
                list.clear();
                this.expandHandler(handlers[i], list, class$org$mortbay$jetty$handler$ContextHandler == null ? ContextHandlerCollection.class$("org.mortbay.jetty.handler.ContextHandler") : class$org$mortbay$jetty$handler$ContextHandler);
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    Handler handler = (Handler)iter.next();
                    String contextPath = ((ContextHandler)handler).getContextPath();
                    if (contextPath == null || contextPath.indexOf(44) >= 0 || contextPath.startsWith("*")) {
                        throw new IllegalArgumentException("Illegal context spec:" + contextPath);
                    }
                    if (!contextPath.startsWith("/")) {
                        contextPath = '/' + contextPath;
                    }
                    if (contextPath.length() > 1) {
                        if (contextPath.endsWith("/")) {
                            contextPath = contextPath + "*";
                        } else if (!contextPath.endsWith("/*")) {
                            contextPath = contextPath + "/*";
                        }
                    }
                    Object contexts = contextMap.get(contextPath);
                    contexts = LazyList.add(contexts, (Object)handlers[i]);
                    contextMap.put(contextPath, contexts);
                }
            }
            this._contextMap = contextMap;
        }
    }

    public void setHandlers(Handler[] handlers) {
        this._contextMap = null;
        super.setHandlers(handlers);
        if (this.isStarted()) {
            this.mapContexts();
        }
    }

    protected void doStart() throws Exception {
        this.mapContexts();
        super.doStart();
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
        Handler[] handlers = this.getHandlers();
        if (handlers == null || handlers.length == 0) {
            response.sendError(500);
        } else {
            Request base_request = HttpConnection.getCurrentConnection().getRequest();
            PathMap map = this._contextMap;
            if (map != null && target != null && target.startsWith("/")) {
                Object contexts = map.getLazyMatches(target);
                for (int i = 0; i < LazyList.size((Object)contexts); ++i) {
                    Map.Entry entry = (Map.Entry)LazyList.get((Object)contexts, (int)i);
                    Object list = entry.getValue();
                    for (int j = 0; j < LazyList.size(list); ++j) {
                        Handler handler = (Handler)LazyList.get(list, (int)j);
                        handler.handle(target, request, response, dispatch);
                        if (!base_request.isHandled()) continue;
                        return;
                    }
                }
            } else {
                for (int i = 0; i < handlers.length; ++i) {
                    handlers[i].handle(target, request, response, dispatch);
                    if (!base_request.isHandled()) continue;
                    return;
                }
            }
        }
    }

    public ContextHandler addContext(String contextPath, String resourceBase) {
        try {
            ContextHandler context = (ContextHandler)this._contextClass.newInstance();
            context.setContextPath(contextPath);
            context.setResourceBase(resourceBase);
            this.addHandler(context);
            return context;
        }
        catch (Exception e) {
            Log.warn((Throwable)e);
            throw new Error(e);
        }
    }

    public Class getContextClass() {
        return this._contextClass;
    }

    public void setContextClass(Class contextClass) {
        if (contextClass == null || !ContextHandler.class.isAssignableFrom(contextClass)) {
            throw new IllegalArgumentException();
        }
        this._contextClass = contextClass;
    }
}

