/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import org.mortbay.io.Buffer;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.NIOBuffer;

public class ChannelEndPoint
implements EndPoint {
    protected ByteChannel _channel;
    protected ByteBuffer[] _gather2;
    protected ByteBuffer[] _gather3;
    protected Socket _socket;
    protected InetSocketAddress _local;
    protected InetSocketAddress _remote;

    public ChannelEndPoint(ByteChannel channel) {
        this._channel = channel;
        if (channel instanceof SocketChannel) {
            this._socket = ((SocketChannel)channel).socket();
        }
    }

    public boolean isBlocking() {
        if (this._channel instanceof SelectableChannel) {
            return ((SelectableChannel)((Object)this._channel)).isBlocking();
        }
        return true;
    }

    public void blockReadable(long millisecs) {
    }

    public void blockWritable(long millisecs) {
    }

    public boolean isOpen() {
        return this._channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        block7: {
            if (this._channel.isOpen()) {
                try {
                    if (!(this._channel instanceof SocketChannel)) break block7;
                    Socket socket = ((SocketChannel)this._channel).socket();
                    try {
                        socket.shutdownOutput();
                    }
                    finally {
                        socket.close();
                    }
                }
                finally {
                    this._channel.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fill(Buffer buffer) throws IOException {
        Buffer buf = buffer.buffer();
        int len = 0;
        if (buf instanceof NIOBuffer) {
            NIOBuffer nbuf = (NIOBuffer)buf;
            ByteBuffer bbuf = nbuf.getByteBuffer();
            NIOBuffer nIOBuffer = nbuf;
            synchronized (nIOBuffer) {
                try {
                    bbuf.position(buffer.putIndex());
                    len = this._channel.read(bbuf);
                }
                finally {
                    buffer.setPutIndex(bbuf.position());
                    bbuf.position(0);
                }
            }
        }
        throw new IOException("Not Implemented");
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush(Buffer buffer) throws IOException {
        Buffer buf = buffer.buffer();
        int len = 0;
        if (buf instanceof NIOBuffer) {
            NIOBuffer nbuf = (NIOBuffer)buf;
            ByteBuffer bbuf = nbuf.getByteBuffer();
            NIOBuffer nIOBuffer = nbuf;
            synchronized (nIOBuffer) {
                try {
                    bbuf.position(buffer.getIndex());
                    bbuf.limit(buffer.putIndex());
                    len = this._channel.write(bbuf);
                }
                finally {
                    if (!buffer.isImmutable()) {
                        buffer.setGetIndex(bbuf.position());
                    }
                    bbuf.position(0);
                    bbuf.limit(bbuf.capacity());
                }
            }
        }
        if (buffer.array() != null) {
            ByteBuffer b = ByteBuffer.wrap(buffer.array(), buffer.getIndex(), buffer.length());
            len = this._channel.write(b);
            if (!buffer.isImmutable()) {
                buffer.setGetIndex(b.position());
            }
        } else {
            throw new IOException("Not Implemented");
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        Buffer buf2;
        int length = 0;
        Buffer buf0 = header == null ? null : header.buffer();
        Buffer buf1 = buffer == null ? null : buffer.buffer();
        Buffer buffer2 = buf2 = trailer == null ? null : trailer.buffer();
        if (this._channel instanceof GatheringByteChannel && header != null && header.length() != 0 && header instanceof NIOBuffer && buffer != null && buffer.length() != 0 && buffer instanceof NIOBuffer) {
            NIOBuffer nbuf0 = (NIOBuffer)buf0;
            NIOBuffer nbuf1 = (NIOBuffer)buf1;
            NIOBuffer nbuf2 = buf2 == null ? null : (NIOBuffer)buf2;
            ByteBuffer bbuf0 = nbuf0.getByteBuffer();
            ByteBuffer bbuf1 = nbuf1.getByteBuffer();
            ByteBuffer bbuf2 = nbuf2 == null ? null : nbuf2.getByteBuffer();
            NIOBuffer nIOBuffer = nbuf0;
            synchronized (nIOBuffer) {
                NIOBuffer nIOBuffer2 = nbuf1;
                synchronized (nIOBuffer2) {
                    block31: {
                        try {
                            bbuf0.position(header.getIndex());
                            bbuf0.limit(header.putIndex());
                            bbuf1.position(buffer.getIndex());
                            bbuf1.limit(buffer.putIndex());
                            if (bbuf2 == null) {
                                ChannelEndPoint channelEndPoint = this;
                                synchronized (channelEndPoint) {
                                    if (this._gather2 == null) {
                                        this._gather2 = new ByteBuffer[2];
                                    }
                                    this._gather2[0] = bbuf0;
                                    this._gather2[1] = bbuf1;
                                    length = (int)((GatheringByteChannel)((Object)this._channel)).write(this._gather2);
                                    break block31;
                                }
                            }
                            NIOBuffer nIOBuffer3 = nbuf2;
                            synchronized (nIOBuffer3) {
                                try {
                                    bbuf2.position(trailer.getIndex());
                                    bbuf2.limit(trailer.putIndex());
                                    ChannelEndPoint channelEndPoint = this;
                                    synchronized (channelEndPoint) {
                                        if (this._gather3 == null) {
                                            this._gather3 = new ByteBuffer[3];
                                        }
                                        this._gather3[0] = bbuf0;
                                        this._gather3[1] = bbuf1;
                                        this._gather3[2] = bbuf2;
                                        length = (int)((GatheringByteChannel)((Object)this._channel)).write(this._gather3);
                                    }
                                }
                                finally {
                                    if (!trailer.isImmutable()) {
                                        trailer.setGetIndex(bbuf2.position());
                                    }
                                    bbuf2.position(0);
                                    bbuf2.limit(bbuf2.capacity());
                                }
                            }
                        }
                        finally {
                            if (!header.isImmutable()) {
                                header.setGetIndex(bbuf0.position());
                            }
                            if (!buffer.isImmutable()) {
                                buffer.setGetIndex(bbuf1.position());
                            }
                            bbuf0.position(0);
                            bbuf1.position(0);
                            bbuf0.limit(bbuf0.capacity());
                            bbuf1.limit(bbuf1.capacity());
                        }
                    }
                }
            }
        }
        if (header != null && header.length() > 0) {
            length = this.flush(header);
        }
        if ((header == null || header.length() == 0) && buffer != null && buffer.length() > 0) {
            length += this.flush(buffer);
        }
        if (!(header != null && header.length() != 0 || buffer != null && buffer.length() != 0 || trailer == null || trailer.length() <= 0)) {
            length += this.flush(trailer);
        }
        return length;
    }

    public ByteChannel getChannel() {
        return this._channel;
    }

    public String getLocalAddr() {
        if (this._socket == null) {
            return null;
        }
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getHostAddress();
    }

    public String getLocalHost() {
        if (this._socket == null) {
            return null;
        }
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getCanonicalHostName();
    }

    public int getLocalPort() {
        if (this._socket == null) {
            return 0;
        }
        if (this._local == null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
        }
        if (this._local == null) {
            return -1;
        }
        return this._local.getPort();
    }

    public String getRemoteAddr() {
        if (this._socket == null) {
            return null;
        }
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        if (this._remote == null) {
            return null;
        }
        return this._remote.getAddress().getHostAddress();
    }

    public String getRemoteHost() {
        if (this._socket == null) {
            return null;
        }
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        return this._remote.getAddress().getCanonicalHostName();
    }

    public int getRemotePort() {
        if (this._socket == null) {
            return 0;
        }
        if (this._remote == null) {
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
        }
        return this._remote == null ? -1 : this._remote.getPort();
    }

    public Object getConnection() {
        return this._channel;
    }
}

