/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.support.BindStatus;

abstract class SelectedValueComparator {
    SelectedValueComparator() {
    }

    public static boolean isSelected(BindStatus bindStatus, Object candidateValue) {
        Object boundValue = SelectedValueComparator.getBoundValue(bindStatus);
        if (boundValue == null) {
            return candidateValue == null;
        }
        boolean selected = false;
        if (boundValue.getClass().isArray()) {
            selected = SelectedValueComparator.collectionCompare(CollectionUtils.arrayToList((Object)boundValue), candidateValue, bindStatus);
        } else if (boundValue instanceof Collection) {
            selected = SelectedValueComparator.collectionCompare((Collection)boundValue, candidateValue, bindStatus);
        } else if (boundValue instanceof Map) {
            selected = SelectedValueComparator.mapCompare((Map)boundValue, candidateValue, bindStatus);
        }
        if (!selected) {
            selected = ObjectUtils.nullSafeEquals((Object)boundValue, (Object)candidateValue) ? true : SelectedValueComparator.exhaustiveCompare(boundValue, candidateValue, bindStatus.getEditor());
        }
        return selected;
    }

    private static boolean mapCompare(Map boundMap, Object candidateValue, BindStatus bindStatus) {
        if (boundMap.containsKey(candidateValue)) {
            return true;
        }
        return SelectedValueComparator.exhaustiveCollectionCompare(boundMap.keySet(), candidateValue, bindStatus.getEditor());
    }

    private static boolean collectionCompare(Collection boundCollection, Object candidateValue, BindStatus bindStatus) {
        if (boundCollection.contains(candidateValue)) {
            return true;
        }
        return SelectedValueComparator.exhaustiveCollectionCompare(boundCollection, candidateValue, bindStatus.getEditor());
    }

    private static Object getBoundValue(BindStatus bindStatus) {
        Object editorValue;
        if (bindStatus == null) {
            return null;
        }
        if (bindStatus.getEditor() != null && (editorValue = bindStatus.getEditor().getValue()) != null) {
            return editorValue;
        }
        return bindStatus.getValue();
    }

    private static boolean exhaustiveCollectionCompare(Collection collection, Object candidateValue, PropertyEditor propertyEditor) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!SelectedValueComparator.exhaustiveCompare(o, candidateValue, propertyEditor)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exhaustiveCompare(Object boundValue, Object candidate, PropertyEditor propertyEditor) {
        String candidateDisplayString = ObjectUtils.getDisplayString((Object)candidate);
        if (boundValue instanceof LabeledEnum) {
            LabeledEnum labeledEnum = (LabeledEnum)boundValue;
            String enumCodeAsString = ObjectUtils.getDisplayString((Object)labeledEnum.getCode());
            if (enumCodeAsString.equals(candidateDisplayString)) {
                return true;
            }
            String enumLabelAsString = ObjectUtils.getDisplayString((Object)labeledEnum.getLabel());
            if (enumLabelAsString.equals(candidateDisplayString)) {
                return true;
            }
        } else {
            if (ObjectUtils.getDisplayString((Object)boundValue).equals(candidateDisplayString)) {
                return true;
            }
            if (propertyEditor != null && candidate instanceof String) {
                Object originalValue = propertyEditor.getValue();
                String candidateAsString = (String)candidate;
                try {
                    propertyEditor.setAsText(candidateAsString);
                    if (ObjectUtils.nullSafeEquals((Object)boundValue, (Object)propertyEditor.getValue())) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    propertyEditor.setValue(originalValue);
                }
                if (propertyEditor.getValue() != null) {
                    return ObjectUtils.nullSafeEquals((Object)candidateAsString, (Object)propertyEditor.getAsText());
                }
            }
        }
        return false;
    }
}

