/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import org.opennms.core.utils.ThreadCategory;

public class StringUtils {
    public static String[] createCommandArray(String s, char delim) {
        if (s == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (s.indexOf(delim) != -1) {
            throw new IllegalArgumentException("String parameter cannot already contain delimiter character: " + delim);
        }
        char[] chars = s.toCharArray();
        boolean inquote = false;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\"') {
                inquote = !inquote;
                continue;
            }
            if (inquote && chars[i] == ' ') {
                buffer.append(delim);
                continue;
            }
            buffer.append(chars[i]);
        }
        s = buffer.toString();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(s);
        while (tokenizer.hasMoreTokens()) {
            arrayList.add(tokenizer.nextElement());
        }
        String[] list = arrayList.toArray(new String[arrayList.size()]);
        for (int i = 0; i < list.length; ++i) {
            list[i] = list[i].replace(delim, ' ');
        }
        return list;
    }

    public static String[] tokenizeWithQuotingAndEscapes(String line, String delims, boolean processQuoted) {
        Category log = ThreadCategory.getInstance(StringUtils.class);
        LinkedList<String> tokenList = new LinkedList<String>();
        StringBuffer currToken = new StringBuffer();
        boolean quoting = false;
        boolean escaping = false;
        boolean debugTokens = Boolean.getBoolean("org.opennms.netmgt.rrd.debugTokens");
        if (debugTokens) {
            log.debug((Object)("tokenize: line=" + line + " delims=" + delims));
        }
        for (int i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (debugTokens) {
                log.debug((Object)("tokenize: checking char: " + ch));
            }
            if (escaping) {
                if (ch == 'n') {
                    currToken.append('\n');
                } else if (ch == 'r') {
                    currToken.append('\r');
                } else if (ch == 't') {
                    currToken.append('\t');
                } else {
                    currToken.append(ch);
                }
                escaping = false;
                if (!debugTokens) continue;
                log.debug((Object)("tokenize: escaped. appended to " + currToken));
                continue;
            }
            if (ch == '\\') {
                if (debugTokens) {
                    log.debug((Object)("tokenize: found a backslash... escaping currToken = " + currToken));
                }
                if (quoting && !processQuoted) {
                    currToken.append(ch);
                    continue;
                }
                escaping = true;
                continue;
            }
            if (ch == '\"') {
                if (!processQuoted) {
                    currToken.append(ch);
                }
                if (quoting) {
                    if (debugTokens) {
                        log.debug((Object)("tokenize: found a quote ending quotation currToken = " + currToken));
                    }
                    quoting = false;
                    continue;
                }
                if (debugTokens) {
                    log.debug((Object)("tokenize: found a quote beginning quotation  currToken =" + currToken));
                }
                quoting = true;
                continue;
            }
            if (!quoting && delims.indexOf(ch) >= 0) {
                if (debugTokens) {
                    log.debug((Object)("tokenize: found a token: " + ch + " ending token [" + currToken + "] and starting a new one"));
                }
                tokenList.add(currToken.toString());
                currToken = new StringBuffer();
                continue;
            }
            if (debugTokens) {
                log.debug((Object)("tokenize: appending " + ch + " to token: " + currToken));
            }
            currToken.append(ch);
        }
        if (escaping || quoting) {
            if (debugTokens) {
                log.debug((Object)("tokenize: ended string but escaping = " + escaping + " and quoting = " + quoting));
            }
            throw new IllegalArgumentException("unable to tokenize string " + line + " with token chars " + delims);
        }
        if (debugTokens) {
            log.debug((Object)("tokenize: reached end of string.  completing token " + currToken));
        }
        tokenList.add(currToken.toString());
        return tokenList.toArray(new String[tokenList.size()]);
    }

    public static String truncate(String name, int length) {
        if (name.length() <= length) {
            return name;
        }
        return name.substring(0, length);
    }
}

