/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class PropertiesUtils {
    public static String substitute(String initialString, Properties properties) {
        return PropertiesUtils.substitute(initialString, new PropertyBasedSymbolTable(properties));
    }

    public static String substitute(String initialString, SymbolTable symbols) {
        return PropertiesUtils.substitute(initialString, symbols, new ArrayList());
    }

    private static String substitute(String initialString, SymbolTable symTable, List list) {
        if (initialString == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(initialString);
        int startIndex = 0;
        while (startIndex >= 0) {
            int endIndex;
            int beginIndex = result.indexOf("${", startIndex);
            int n = endIndex = beginIndex < 0 ? -1 : result.indexOf("}", beginIndex + "${".length());
            if (endIndex >= 0) {
                String symbol = result.substring(beginIndex + "${".length(), endIndex);
                if (list.contains(symbol)) {
                    throw new IllegalStateException("recursive loop involving symbol ${" + symbol + "}");
                }
                String symbolVal = symTable.getSymbolValue(symbol);
                if (symbolVal != null) {
                    list.add(symbol);
                    String substVal = PropertiesUtils.substitute(symbolVal, symTable, list);
                    list.remove(list.size() - 1);
                    result.replace(beginIndex, endIndex + 1, substVal);
                    startIndex = beginIndex + substVal.length();
                    continue;
                }
                startIndex = endIndex + 1;
                continue;
            }
            startIndex = -1;
        }
        return result.toString();
    }

    private static class PropertyBasedSymbolTable
    implements SymbolTable {
        Properties m_properties;

        PropertyBasedSymbolTable(Properties properties) {
            this.m_properties = properties;
        }

        public String getSymbolValue(String symbol) {
            return this.m_properties.getProperty(symbol);
        }
    }

    public static interface SymbolTable {
        public String getSymbolValue(String var1);
    }
}

