/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.concurrent;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;
import org.opennms.core.fiber.Fiber;
import org.opennms.core.queue.ClosableFifoQueue;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueClosedException;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.queue.FifoQueueImpl;
import org.opennms.core.utils.ThreadCategory;

public class RunnableConsumerThreadPool
implements Fiber {
    private SizingFifoQueue m_delegateQ;
    private Fiber[] m_fibers;
    private String m_poolName;
    private float m_hiRatio;
    private float m_loRatio;
    private int m_maxSize;
    private String m_log4jPrefix;
    private int m_poolStatus;
    private List m_completedListeners;
    private ThreadGroup m_tGroup;
    private List m_errorListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int livingFiberCount() {
        int alive = 0;
        Fiber[] fiberArray = this.m_fibers;
        synchronized (this.m_fibers) {
            for (int i = 0; i < this.m_fibers.length; ++i) {
                if (this.m_fibers[i] == null) continue;
                if (this.m_fibers[i].getStatus() != 4) {
                    ++alive;
                    continue;
                }
                this.m_fibers[i] = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return alive;
        }
    }

    public RunnableConsumerThreadPool(String name, float loMark, float hiMark, int max) {
        if (loMark > hiMark) {
            throw new IllegalArgumentException("The lo-mark must be less than the hi-mark");
        }
        if (max <= 0) {
            throw new IllegalArgumentException("The maximum number of fibers must be greater than zero");
        }
        this.m_delegateQ = new SizingFifoQueue();
        this.m_fibers = new Fiber[max];
        this.m_poolName = name;
        this.m_hiRatio = hiMark;
        this.m_loRatio = loMark;
        this.m_maxSize = max;
        this.m_tGroup = new ThreadGroup(name + "-tgroup");
        this.m_poolStatus = 0;
        this.m_completedListeners = new ArrayList();
        this.m_errorListeners = new ArrayList();
        this.m_log4jPrefix = ThreadCategory.getPrefix();
    }

    public FifoQueue getRunQueue() {
        return this.m_delegateQ;
    }

    public void start() {
        try {
            this.m_delegateQ.open();
        }
        catch (FifoQueueException fe) {
            throw new RuntimeException(fe.getMessage());
        }
        this.m_poolStatus = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Fiber[] fiberArray = this.m_fibers;
        synchronized (this.m_fibers) {
            for (int i = 0; i < this.m_fibers.length; ++i) {
                if (this.m_fibers[i] == null) continue;
                this.m_fibers[i].stop();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.m_poolStatus = 3;
            try {
                this.m_delegateQ.close();
            }
            catch (FifoQueueException fe) {
                throw new RuntimeException(fe.getMessage());
            }
            return;
        }
    }

    public int getStatus() {
        if (this.m_poolStatus == 3 && this.livingFiberCount() == 0) {
            this.m_poolStatus = 4;
        }
        return this.m_poolStatus;
    }

    public String getName() {
        return this.m_poolName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletionListener(RunnableCompletionListener listener) {
        List list = this.m_completedListeners;
        synchronized (list) {
            this.m_completedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCompletionListener(RunnableCompletionListener listener) {
        List list = this.m_completedListeners;
        synchronized (list) {
            this.m_completedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorListener(RunnableErrorListener listener) {
        List list = this.m_errorListeners;
        synchronized (list) {
            this.m_errorListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeErrorListener(RunnableErrorListener listener) {
        List list = this.m_errorListeners;
        synchronized (list) {
            this.m_errorListeners.remove(listener);
        }
    }

    public static interface RunnableErrorListener {
        public void onRunnableError(Object var1, Throwable var2);
    }

    public static interface RunnableCompletionListener {
        public void onRunnableCompletion(Runnable var1);
    }

    private class FiberThreadImpl
    implements Fiber,
    Runnable {
        private Thread m_delegateThread;
        private volatile boolean m_shutdown = false;
        private volatile int m_status = 0;

        FiberThreadImpl(String name) {
            this.m_delegateThread = new Thread(RunnableConsumerThreadPool.this.m_tGroup, this, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadCategory.setPrefix(RunnableConsumerThreadPool.this.m_log4jPrefix);
            this.m_status = 2;
            while (!this.m_shutdown) {
                Object obj = null;
                try {
                    obj = RunnableConsumerThreadPool.this.m_delegateQ.remove(500L);
                    if (obj == null) {
                        continue;
                    }
                }
                catch (InterruptedException ie) {
                    this.m_status = 3;
                    break;
                }
                catch (FifoQueueException fqE) {
                    this.m_status = 3;
                    break;
                }
                try {
                    if (obj == null) continue;
                    ((Runnable)obj).run();
                    Object[] list = null;
                    List list2 = RunnableConsumerThreadPool.this.m_completedListeners;
                    synchronized (list2) {
                        list = RunnableConsumerThreadPool.this.m_completedListeners.toArray();
                    }
                    for (int i = 0; list != null && i < list.length; ++i) {
                        ((RunnableCompletionListener)list[i]).onRunnableCompletion((Runnable)obj);
                    }
                }
                catch (Throwable t) {
                    Category log = ThreadCategory.getInstance(this.getClass());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"run: an unexpected error occured during fiber run, calling error liseners");
                    }
                    Object[] list = null;
                    List list3 = RunnableConsumerThreadPool.this.m_errorListeners;
                    synchronized (list3) {
                        list = RunnableConsumerThreadPool.this.m_errorListeners.toArray();
                    }
                    if (list.length == 0) {
                        log.error((Object)"No error listeners defined for for unexpected error ", t);
                    }
                    for (int i = 0; list != null && i < list.length; ++i) {
                        ((RunnableErrorListener)list[i]).onRunnableError(obj, t);
                    }
                }
            }
            this.m_status = 4;
        }

        public void start() {
            this.m_status = 1;
            this.m_shutdown = false;
            this.m_delegateThread.start();
        }

        public void stop() {
            this.m_status = 3;
            this.m_shutdown = true;
        }

        public String getName() {
            return this.m_delegateThread.getName();
        }

        public int getStatus() {
            return this.m_status;
        }
    }

    private class SizingFifoQueue
    extends FifoQueueImpl
    implements ClosableFifoQueue {
        private volatile boolean m_isClosed = false;

        private SizingFifoQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adjust() {
            block12: {
                int e = this.size();
                Fiber[] fiberArray = RunnableConsumerThreadPool.this.m_fibers;
                synchronized (fiberArray) {
                    float ratio;
                    int alive;
                    block11: {
                        alive = RunnableConsumerThreadPool.this.livingFiberCount();
                        ratio = (float)e / (float)(alive <= 0 ? 1 : alive);
                        if (alive <= 1 || !(ratio <= RunnableConsumerThreadPool.this.m_loRatio)) break block11;
                        Fiber f = null;
                        int last = 0;
                        block7: for (int x = 0; x < RunnableConsumerThreadPool.this.m_fibers.length; ++x) {
                            if (RunnableConsumerThreadPool.this.m_fibers[x] == null) continue;
                            switch (RunnableConsumerThreadPool.this.m_fibers[x].getStatus()) {
                                case 2: {
                                    if (last >= 2) continue block7;
                                    f = RunnableConsumerThreadPool.this.m_fibers[x];
                                    last = f.getStatus();
                                    continue block7;
                                }
                                case 3: {
                                    if (last >= 3) continue block7;
                                    f = null;
                                    last = 3;
                                }
                            }
                        }
                        if (f == null || f.getStatus() == 3) break block12;
                        Category log = ThreadCategory.getInstance(this.getClass());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("adjust: calling stop on fiber " + f.getName()));
                        }
                        f.stop();
                        break block12;
                    }
                    if ((alive == 0 && e > 0 || ratio > RunnableConsumerThreadPool.this.m_hiRatio) && alive < RunnableConsumerThreadPool.this.m_maxSize) {
                        for (int x = 0; x < RunnableConsumerThreadPool.this.m_fibers.length; ++x) {
                            if (RunnableConsumerThreadPool.this.m_fibers[x] != null && RunnableConsumerThreadPool.this.m_fibers[x].getStatus() != 4) continue;
                            FiberThreadImpl f = new FiberThreadImpl(RunnableConsumerThreadPool.this.m_poolName + "-fiber" + x);
                            f.start();
                            ((RunnableConsumerThreadPool)RunnableConsumerThreadPool.this).m_fibers[x] = f;
                            Category log = ThreadCategory.getInstance(this.getClass());
                            if (!log.isDebugEnabled()) break;
                            log.debug((Object)("adjust: started fiber " + f.getName() + " ratio = " + ratio + ", alive = " + alive));
                            break;
                        }
                    }
                }
            }
        }

        public boolean isOpen() {
            return !this.m_isClosed;
        }

        public boolean isClosed() {
            return this.m_isClosed;
        }

        public void close() throws FifoQueueException {
            this.m_isClosed = true;
        }

        public void open() throws FifoQueueException {
            this.m_isClosed = false;
        }

        public void add(Object element) throws FifoQueueException, InterruptedException {
            if (this.m_isClosed) {
                throw new FifoQueueClosedException("Queue Closed");
            }
            super.add(element);
            this.adjust();
        }

        public boolean add(Object element, long timeout) throws FifoQueueException, InterruptedException {
            if (this.m_isClosed) {
                throw new FifoQueueClosedException("Queue Closed");
            }
            boolean result = super.add(element, timeout);
            this.adjust();
            return result;
        }

        public Object remove() throws FifoQueueException, InterruptedException {
            if (this.m_isClosed && this.size() == 0) {
                throw new FifoQueueClosedException("Queue Closed");
            }
            Object result = super.remove();
            this.adjust();
            return result;
        }

        public Object remove(long timeout) throws FifoQueueException, InterruptedException {
            if (this.m_isClosed && this.size() == 0) {
                throw new FifoQueueClosedException("Queue Closed");
            }
            Object result = super.remove(timeout);
            this.adjust();
            return result;
        }
    }
}

