/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vulnscand;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.concurrent.RunnableConsumerThreadPool;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.VulnscandConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.opennms.netmgt.vulnscand.BroadcastEventProcessor;
import org.opennms.netmgt.vulnscand.Scheduler;

public class Vulnscand
extends AbstractServiceDaemon {
    private static final String LOG4J_CATEGORY = "OpenNMS.Vulnscand";
    private static final Vulnscand m_singleton = new Vulnscand();
    private static Object m_dbSyncLock = new Object();
    private static String m_address = null;
    private Scheduler m_scheduler = null;
    private BroadcastEventProcessor m_receiver;
    private RunnableConsumerThreadPool m_specificScanRunner;
    private RunnableConsumerThreadPool m_scheduledScanRunner;

    public Vulnscand() {
        super(LOG4J_CATEGORY);
    }

    protected void onStop() {
        this.m_receiver.close();
        this.m_specificScanRunner.stop();
        this.m_scheduledScanRunner.stop();
    }

    protected void onStart() {
        try {
            VulnscandConfigFactory.reload();
        }
        catch (MarshalException ex) {
            this.log().error((Object)"Failed to load Vulnscand configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (ValidationException ex) {
            this.log().error((Object)"Failed to load Vulnscand configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        catch (IOException ex) {
            this.log().error((Object)"Failed to load Vulnscand configuration", (Throwable)ex);
            throw new UndeclaredThrowableException(ex);
        }
        try {
            DataSourceFactory.init();
        }
        catch (IOException ie) {
            this.log().fatal((Object)"IOException loading database config", (Throwable)ie);
            throw new UndeclaredThrowableException(ie);
        }
        catch (MarshalException me) {
            this.log().fatal((Object)"Marshall Exception loading database config", (Throwable)me);
            throw new UndeclaredThrowableException(me);
        }
        catch (ValidationException ve) {
            this.log().fatal((Object)"Validation Exception loading database config", (Throwable)ve);
            throw new UndeclaredThrowableException(ve);
        }
        catch (ClassNotFoundException ce) {
            this.log().fatal((Object)"Class lookup failure loading database config", (Throwable)ce);
            throw new UndeclaredThrowableException(ce);
        }
        catch (PropertyVetoException e) {
            this.log().fatal((Object)"Property Veto Exception loading database config", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        catch (SQLException e) {
            this.log().fatal((Object)"SQL Exception loading database config", (Throwable)e);
            throw new UndeclaredThrowableException(e);
        }
        this.m_specificScanRunner = new RunnableConsumerThreadPool("Vulnscand Scan Pool", 0.6f, 1.0f, VulnscandConfigFactory.getInstance().getMaxSuspectThreadPoolSize());
        this.m_scheduledScanRunner = new RunnableConsumerThreadPool("Vulnscand Rescan Pool", 0.6f, 1.0f, VulnscandConfigFactory.getInstance().getMaxRescanThreadPoolSize());
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"start: Starting runnable thread pools...");
        }
        this.m_specificScanRunner.start();
        this.m_scheduledScanRunner.start();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)"start: Creating rescan scheduler");
        }
        try {
            this.m_scheduler = new Scheduler(this.m_scheduledScanRunner.getRunQueue());
        }
        catch (SQLException sqlE) {
            this.log().error((Object)"Failed to initialize the rescan scheduler.", (Throwable)sqlE);
            throw new UndeclaredThrowableException(sqlE);
        }
        catch (Throwable t) {
            this.log().error((Object)"Failed to initialize the rescan scheduler.", t);
        }
        this.m_scheduler.start();
        try {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"start: Creating event broadcast event receiver");
            }
            this.m_receiver = new BroadcastEventProcessor(this.m_specificScanRunner.getRunQueue(), this.m_scheduler);
        }
        catch (Throwable t) {
            this.log().error((Object)"Failed to initialized the broadcast event receiver", t);
            throw new UndeclaredThrowableException(t);
        }
    }

    public static String getLocalHostAddress() {
        return m_address;
    }

    public static Vulnscand getInstance() {
        return m_singleton;
    }

    static Object getDbSyncLock() {
        return m_dbSyncLock;
    }

    protected void onInit() {
    }

    static {
        try {
            m_address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException uhE) {
            m_address = "localhost";
            ThreadCategory.getInstance((String)LOG4J_CATEGORY).warn((Object)"Could not lookup the host name for the local host machine, address set to \"localhost\"", (Throwable)uhE);
        }
    }
}

