/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vulnscand;

import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Category;
import org.opennms.core.fiber.PausableFiber;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.queue.FifoQueueException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.config.VulnscandConfigFactory;
import org.opennms.netmgt.config.vulnscand.ScanLevel;
import org.opennms.netmgt.config.vulnscand.VulnscandConfiguration;
import org.opennms.netmgt.vulnscand.NessusScan;
import org.opennms.netmgt.vulnscand.NessusScanConfiguration;

final class Scheduler
implements Runnable,
PausableFiber {
    private static final String FIBER_NAME = "Vulnscand Scheduler";
    private static final String SQL_DB_RETRIEVE_IP_INTERFACE = "SELECT ipaddr FROM ipinterface WHERE ipaddr!='0.0.0.0' AND isManaged!='D' AND isManaged!='F'";
    private static final String SQL_GET_LAST_POLL_TIME = "SELECT lastAttemptTime FROM vulnerabilities WHERE ipaddr=? ORDER BY lastAttemptTime DESC";
    private String m_name;
    private int m_status;
    private Thread m_worker;
    private List m_knownAddresses;
    private long m_interval;
    private long m_initialSleep;
    private FifoQueue m_scheduledScanQ;

    Scheduler(FifoQueue rescanQ) throws SQLException {
        Category log = ThreadCategory.getInstance(Scheduler.class);
        this.m_scheduledScanQ = rescanQ;
        this.m_name = FIBER_NAME;
        this.m_status = 0;
        this.m_worker = null;
        this.m_knownAddresses = Collections.synchronizedList(new LinkedList());
        this.m_interval = VulnscandConfigFactory.getInstance().getRescanFrequency();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scheduler: rescan interval(millis): " + this.m_interval));
        }
        this.m_initialSleep = VulnscandConfigFactory.getInstance().getInitialSleepTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Scheduler: initial rescan sleep time(millis): " + this.m_initialSleep));
        }
        VulnscandConfigFactory configFactory = VulnscandConfigFactory.getInstance();
        VulnscandConfiguration config = VulnscandConfigFactory.getConfiguration();
        if (config.getStatus()) {
            Enumeration scanLevels = config.enumerateScanLevel();
            while (scanLevels.hasMoreElements()) {
                ScanLevel scanLevel = (ScanLevel)scanLevels.nextElement();
                int level = scanLevel.getLevel();
                TreeSet levelAddresses = new TreeSet();
                if (configFactory.getManagedInterfacesStatus() && configFactory.getManagedInterfacesScanLevel() == level) {
                    levelAddresses.addAll(this.getAllManagedInterfaces());
                    log.info((Object)("Scheduled the managed interfaces at scan level " + level + "."));
                }
                levelAddresses.removeAll(configFactory.getAllExcludes());
                log.info((Object)("Adding " + levelAddresses.size() + " addresses to the vulnerability scan scheduler."));
                for (Object next : levelAddresses) {
                    String nextAddress = null;
                    if (next instanceof String) {
                        nextAddress = (String)next;
                        log.debug((Object)("JOHAN LevelAddresses : " + nextAddress));
                    }
                    try {
                        InetAddress frump = InetAddress.getByName(nextAddress);
                        this.addToKnownAddresses(frump, level);
                    }
                    catch (UnknownHostException ex) {
                        log.error((Object)("Could not add invalid address to schedule: " + nextAddress), (Throwable)ex);
                    }
                }
            }
        } else {
            log.info((Object)"Vulnerability scanning is DISABLED.");
        }
    }

    private Set getAllManagedInterfaces() {
        Category log = ThreadCategory.getInstance(Scheduler.class);
        TreeSet<String> retval = new TreeSet<String>();
        String addressString = null;
        Connection connection = null;
        Statement selectInterfaces = null;
        ResultSet interfaces = null;
        try {
            connection = DataSourceFactory.getInstance().getConnection();
            selectInterfaces = connection.createStatement();
            interfaces = selectInterfaces.executeQuery(SQL_DB_RETRIEVE_IP_INTERFACE);
            int i = 0;
            while (interfaces.next()) {
                addressString = interfaces.getString(1);
                if (addressString != null) {
                    retval.add(addressString);
                    log.debug((Object)("JOHAN: " + addressString));
                } else {
                    log.warn((Object)"UNEXPECTED CONDITION: NULL string in the results of the query for managed interfaces from the ipinterface table.");
                }
                ++i;
            }
            log.info((Object)("Loaded " + i + " managed interfaces from the database."));
        }
        catch (SQLException ex) {
            log.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToKnownAddresses(InetAddress address, int scanLevel) throws SQLException {
        Category log = ThreadCategory.getInstance(this.getClass());
        Connection db = null;
        try {
            db = DataSourceFactory.getInstance().getConnection();
            PreparedStatement ifStmt = db.prepareStatement(SQL_GET_LAST_POLL_TIME);
            ifStmt.setString(1, address.getHostAddress());
            ResultSet rset = ifStmt.executeQuery();
            if (rset.next()) {
                Timestamp lastPolled = rset.getTimestamp(1);
                if (lastPolled != null && !rset.wasNull()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("scheduleAddress: adding node " + address + " with last poll time " + lastPolled));
                    }
                    this.m_knownAddresses.add(new NessusScanConfiguration(address, scanLevel, lastPolled, this.m_interval));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("scheduleAddress: adding ipAddr " + address + " with no previous poll"));
                }
                this.m_knownAddresses.add(new NessusScanConfiguration(address, scanLevel, new Timestamp(0L), this.m_interval));
            }
        }
        finally {
            if (db != null) {
                try {
                    db.close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unscheduleAddress(InetAddress address) {
        List list = this.m_knownAddresses;
        synchronized (list) {
            for (NessusScanConfiguration addressInfo : this.m_knownAddresses) {
                if (addressInfo.getAddress() != address) continue;
                ThreadCategory.getInstance(this.getClass()).debug((Object)("unscheduleAddress: removing node " + address + " from the scheduler."));
                this.m_knownAddresses.remove(addressInfo);
                break;
            }
        }
    }

    public static InetAddress toInetAddress(long address) throws UnknownHostException {
        StringBuffer buf = new StringBuffer();
        buf.append((int)(address >>> 24 & 0xFFL)).append('.');
        buf.append((int)(address >>> 16 & 0xFFL)).append('.');
        buf.append((int)(address >>> 8 & 0xFFL)).append('.');
        buf.append((int)(address & 0xFFL));
        return InetAddress.getByName(buf.toString());
    }

    public synchronized void start() {
        if (this.m_worker != null) {
            throw new IllegalStateException("The fiber has already run or is running");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_worker = new Thread((Runnable)this, this.getName());
        this.m_worker.start();
        this.m_status = 1;
        log.debug((Object)"Scheduler.start: scheduler started");
    }

    public synchronized void stop() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_status = 3;
        this.m_worker.interrupt();
        log.debug((Object)"Scheduler.stop: scheduler stopped");
    }

    public synchronized void pause() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 6) {
            return;
        }
        this.m_status = 5;
        this.notifyAll();
    }

    public synchronized void resume() {
        if (this.m_worker == null) {
            throw new IllegalStateException("The fiber has never been started");
        }
        if (this.m_status == 4 || this.m_status == 3) {
            throw new IllegalStateException("The fiber is not running or a stop is pending");
        }
        if (this.m_status == 2) {
            return;
        }
        this.m_status = 7;
        this.notifyAll();
    }

    public synchronized int getStatus() {
        if (this.m_worker != null && !this.m_worker.isAlive()) {
            this.m_status = 4;
        }
        return this.m_status;
    }

    public String getName() {
        return FIBER_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Category log = ThreadCategory.getInstance(this.getClass());
        Scheduler scheduler = this;
        synchronized (scheduler) {
            this.m_status = 2;
        }
        log.debug((Object)"Scheduler.run: scheduler running");
        boolean firstPass = true;
        while (true) {
            Scheduler scheduler2 = this;
            synchronized (scheduler2) {
                if (this.m_status != 2 && this.m_status != 6 && this.m_status != 5 && this.m_status != 7) {
                    log.debug((Object)("Scheduler.run: status = " + this.m_status + ", time to exit"));
                    break;
                }
            }
            if (firstPass) {
                firstPass = false;
                scheduler2 = this;
                synchronized (scheduler2) {
                    try {
                        log.debug((Object)("Scheduler.run: initial sleep configured for " + this.m_initialSleep + "ms...sleeping..."));
                        this.wait(this.m_initialSleep);
                    }
                    catch (InterruptedException ex) {
                        log.debug((Object)"Scheduler.run: interrupted exception during initial sleep...exiting.");
                        break;
                    }
                }
            }
            int added = 0;
            Object object = this.m_knownAddresses;
            synchronized (object) {
                log.debug((Object)"Scheduler.run: iterating over known nodes list to schedule...");
                for (NessusScanConfiguration addressInfo : this.m_knownAddresses) {
                    log.debug((Object)("Scheduler.run: working on " + addressInfo.getAddress().toString()));
                    if (addressInfo.isScheduled() || !addressInfo.isTimeForRescan()) continue;
                    try {
                        addressInfo.setScheduled(true);
                        log.debug((Object)("Scheduler.run: adding node " + addressInfo.getAddress().toString() + " to the rescan queue."));
                        this.m_scheduledScanQ.add((Object)new NessusScan(addressInfo));
                        ++added;
                    }
                    catch (InterruptedException ex) {
                        log.info((Object)"Scheduler.schedule: failed to add new node to rescan queue", (Throwable)ex);
                        throw new UndeclaredThrowableException(ex);
                    }
                    catch (FifoQueueException ex) {
                        log.info((Object)"Scheduler.schedule: failed to add new node to rescan queue", (Throwable)ex);
                        throw new UndeclaredThrowableException(ex);
                    }
                }
            }
            object = this;
            synchronized (object) {
                if (added == 0) {
                    try {
                        this.wait(60000L);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
        }
        log.debug((Object)"Scheduler.run: scheduler exiting, state = STOPPED");
        Scheduler scheduler3 = this;
        synchronized (scheduler3) {
            this.m_status = 4;
        }
    }
}

