/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vulnscand;

import org.apache.log4j.Category;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.vulnscand.DescrValues;
import org.opennms.netmgt.vulnscand.PortValues;

public class NessusParser {
    private static NessusParser instance;
    private static RE cveId;
    private static RE cveString;
    private static RE riskFactor;
    private static RE semicolonSingle;
    private static RE semicolonMulti;
    private static RE multipleAsterisks;
    private static RE nessusLine;
    private static RE nessusSentence;
    private static RE nessusTag;
    private static RE nessusInside;
    private static RE tooManyBreaks;
    private static RE leadingOrTrailingBreaks;
    private static RE protocolWithPort;
    private static RE protocolWithoutPort;
    private static RE indeterminate;
    private static RE informational;
    private static RE normal;
    private static RE normal2;
    private static RE warning;
    private static RE minor;
    private static RE critical;
    private static RE major;
    private static RE greaterThan;
    private static RE lessThan;
    private static RE greaterThanToken;
    private static RE lessThanToken;
    private static final String GREATER_THAN_TOKEN = "GREATERTHANSIGN";
    private static final String GREATER_THAN_ENTITY = "&gt;";
    private static final String LESS_THAN_TOKEN = "LESSTHANSIGN";
    private static final String LESS_THAN_ENTITY = "&lt;";

    private NessusParser() {
        this.initREs();
    }

    private void initREs() {
        try {
            semicolonSingle = new RE("[:space:]*;([:space:]|\\*)*");
            semicolonMulti = new RE("([:space:]*;){2,}([:space:]|\\*)*");
            multipleAsterisks = new RE("([:space:]*\\*){2,}[:space:]*");
            nessusLine = new RE("^[Nn]essus[Dd]{0,1}");
            nessusSentence = new RE("\\.([:space:]|;)*[Nn]essus[Dd]{0,1}");
            nessusTag = new RE(">([:space:]|;)*[Nn]essus[Dd]{0,1}");
            nessusInside = new RE("[Nn]essus[Dd]{0,1}");
            cveId = new RE("[Cc](([Vv][Ee])|([Aa][Nn]))-[0-9]{4}-[0-9]{4}");
            cveString = new RE("[:space:]*[Cc][Vv][Ee][:space:]*:[:space:]*([^;]*)");
            riskFactor = new RE("[:space:]*[Rr]isk[:space:]*[Ff]actor[:space:]*:([:space:]|;)*([^;{1,2}]*)");
            informational = new RE("([Ii]nfo)");
            normal = new RE("([Nn]one)");
            normal2 = new RE("(;;[Nn]one)");
            warning = new RE("([Ll]ow)");
            minor = new RE("([Mm]edium)");
            major = new RE("([Hh]igh)");
            critical = new RE("([Cc]ritical)|([Ss]erious)");
            tooManyBreaks = new RE("(<br />){3,}");
            leadingOrTrailingBreaks = new RE("((<br />)+$)|(^(<br />)+)");
            protocolWithPort = new RE("[:space:]*[:alnum:]+[:space:]\\(([:alnum:]+)/([:alnum:]+)\\)[:space:]*");
            protocolWithoutPort = new RE("[:space:]*[:alnum:]+/([:alnum:]+)[:space:]*");
            greaterThan = new RE(">");
            lessThan = new RE("<");
            greaterThanToken = new RE(GREATER_THAN_TOKEN);
            lessThanToken = new RE(LESS_THAN_TOKEN);
        }
        catch (RESyntaxException ex) {
            System.out.println("FATAL ERROR in regex in NessusScan.java. Correct this error and rebuild.");
            ex.printStackTrace();
        }
    }

    public static NessusParser getInstance() {
        if (instance == null) {
            instance = new NessusParser();
        }
        return instance;
    }

    public static void main(String[] argv) {
        NessusParser myParser = NessusParser.getInstance();
        System.out.println(myParser.parseDescr(argv[0]));
    }

    public PortValues parsePort(String portString) throws IllegalArgumentException {
        Category log = ThreadCategory.getInstance(this.getClass());
        PortValues retval = new PortValues();
        if (protocolWithPort.match(portString)) {
            try {
                retval.port = Integer.parseInt(protocolWithPort.getParen(1).trim());
            }
            catch (NumberFormatException ex) {
                log.error((Object)("Cannot parse port into an integer: " + portString), (Throwable)ex);
            }
            retval.protocol = protocolWithPort.getParen(2).trim();
        } else if (protocolWithoutPort.match(portString)) {
            retval.protocol = protocolWithoutPort.getParen(1).trim();
        } else {
            log.error((Object)("Invalid service/port/protocol marker in the message: " + portString));
        }
        if (retval.isValid()) {
            return retval;
        }
        throw new IllegalArgumentException("String could not be parsed into a PortValues object");
    }

    public DescrValues parseDescr(String descr) throws IllegalArgumentException {
        String risk;
        Category log = ThreadCategory.getInstance(this.getClass());
        DescrValues retval = new DescrValues();
        if (riskFactor.match(descr = descr.replace('\n', ' '))) {
            risk = riskFactor.getParen(2).trim();
            String risk2 = descr;
            log.debug((Object)("Descr Parsed: " + risk));
            log.debug((Object)("Descr Parsed: " + risk2));
            if (informational.match(risk)) {
                retval.severity = 3;
            }
            if (normal.match(risk)) {
                retval.severity = 3;
            }
            if (normal2.match(risk)) {
                retval.severity = 3;
            }
            if (warning.match(risk)) {
                retval.severity = 4;
            }
            if (minor.match(risk)) {
                retval.severity = 5;
            }
            if (major.match(risk)) {
                retval.severity = 6;
            }
            if (critical.match(risk)) {
                retval.severity = 7;
            }
            if (retval.severity == 0) {
                retval.severity = 1;
            }
            descr = riskFactor.subst(descr, "");
        } else {
            risk = null;
            retval.severity = 1;
        }
        if (cveString.match(descr)) {
            retval.cveEntry = cveString.getParen(1).trim();
            if (!cveId.match(retval.cveEntry)) {
                retval.cveEntry = null;
            } else {
                descr = cveString.subst(descr, "");
            }
        } else {
            retval.cveEntry = null;
        }
        descr = multipleAsterisks.subst(descr, " ");
        descr = greaterThan.subst(descr, GREATER_THAN_TOKEN);
        descr = lessThan.subst(descr, LESS_THAN_TOKEN);
        descr = nessusLine.subst(descr, "The scanner");
        descr = nessusSentence.subst(descr, ". The scanner");
        descr = nessusTag.subst(descr, "> The scanner");
        descr = nessusInside.subst(descr, "the scanner");
        descr = semicolonSingle.subst(descr, "<br />");
        descr = tooManyBreaks.subst(descr, "<br /><br />");
        descr = leadingOrTrailingBreaks.subst(descr, "");
        if (risk != null) {
            descr = descr + "<br /><br />Risk Factor: <b>" + risk + "</b>";
        }
        if (retval.cveEntry != null) {
            descr = descr + "<br /><br />Corresponding CVE Entry: <b>" + retval.cveEntry + "</b>";
        }
        descr = greaterThanToken.subst(descr, GREATER_THAN_ENTITY);
        descr = lessThanToken.subst(descr, LESS_THAN_ENTITY);
        retval.descr = descr.trim();
        if (retval.isValid()) {
            return retval;
        }
        throw new IllegalArgumentException("String could not be parsed into a DescrValues object");
    }

    public static DescrValues getDefaultDescrValues() {
        DescrValues retval = new DescrValues();
        retval.useDefaults();
        return retval;
    }

    public static PortValues getDefaultPortValues() {
        PortValues retval = new PortValues();
        retval.useDefaults();
        return retval;
    }

    static {
        cveId = null;
        cveString = null;
        riskFactor = null;
        semicolonSingle = null;
        semicolonMulti = null;
        multipleAsterisks = null;
        nessusLine = null;
        nessusSentence = null;
        nessusTag = null;
        nessusInside = null;
        tooManyBreaks = null;
        leadingOrTrailingBreaks = null;
        protocolWithPort = null;
        protocolWithoutPort = null;
        indeterminate = null;
        informational = null;
        normal = null;
        normal2 = null;
        warning = null;
        minor = null;
        critical = null;
        major = null;
        greaterThan = null;
        lessThan = null;
        greaterThanToken = null;
        lessThanToken = null;
    }
}

