/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vulnscand;

import java.util.ArrayList;
import org.apache.log4j.Category;
import org.opennms.core.queue.FifoQueue;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.eventd.EventListener;
import org.opennms.netmgt.vulnscand.Scheduler;
import org.opennms.netmgt.xml.event.Event;

final class BroadcastEventProcessor
implements EventListener {
    private static String SQL_RETRIEVE_NODEID = "select nodeid from ipinterface where ipaddr=? and isManaged!='D'";
    private FifoQueue m_suspectQ;
    private Scheduler m_scheduler;

    private void installJmsMessageSelector() {
        ArrayList<String> ueiList = new ArrayList<String>();
        ueiList.add("uei.opennms.org/vulnscand/specificVulnerabilityScan");
        EventIpcManagerFactory.getIpcManager().addEventListener((EventListener)this, ueiList);
    }

    BroadcastEventProcessor(FifoQueue suspectQ, Scheduler scheduler) {
        Category log = ThreadCategory.getInstance(this.getClass());
        this.m_suspectQ = suspectQ;
        this.m_scheduler = scheduler;
        this.installJmsMessageSelector();
    }

    synchronized void close() {
        EventIpcManagerFactory.getIpcManager().removeEventListener(this);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public void onEvent(Event event) {
        Category log = ThreadCategory.getInstance(this.getClass());
        String eventUei = event.getUei();
        if (eventUei == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received event: " + eventUei));
        }
        if (!eventUei.equals("uei.opennms.org/vulnscand/specificVulnerabilityScan")) {
            log.error((Object)("Cannot process event with UEI: " + event.getUei()));
        }
    }

    public String getName() {
        return "Vulnscand:BroadcastEventProcessor";
    }
}

